/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration.cli.commands;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.console.command.CommandException;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.keycloak.client.registration.cli.commands.AbstractGlobalOptionsCmd;
import org.keycloak.client.registration.cli.common.AttributeKey;
import org.keycloak.client.registration.cli.common.EndpointType;
import org.keycloak.client.registration.cli.util.OsUtil;
import org.keycloak.client.registration.cli.util.ReflectionUtil;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;

@CommandDefinition(name="attrs", description="[ATTRIBUTE] [--endpoint TYPE]")
public class AttrsCmd
extends AbstractGlobalOptionsCmd {
    @Option(shortName=101, name="endpoint", description="Endpoint type to use", hasValue=true)
    protected String endpoint;
    @Arguments
    protected List<String> args;
    protected String attr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        try {
            String ts;
            Class<ClientRepresentation> type;
            this.processGlobalOptions();
            if (this.printHelp()) {
                CommandResult commandResult = CommandResult.SUCCESS;
                return commandResult;
            }
            EndpointType regType = EndpointType.DEFAULT;
            PrintStream out = commandInvocation.getShell().out();
            if (this.endpoint != null) {
                regType = EndpointType.of(this.endpoint);
            }
            if (this.args != null) {
                if (this.args.size() > 1) {
                    throw new RuntimeException("Invalid option: " + this.args.get(1));
                }
                this.attr = this.args.get(0);
            }
            Class clazz = regType == EndpointType.DEFAULT ? ClientRepresentation.class : (type = regType == EndpointType.OIDC ? OIDCClientRepresentation.class : null);
            if (type == null) {
                throw new RuntimeException("Endpoint not supported: " + (Object)((Object)regType));
            }
            AttributeKey key = this.attr == null ? new AttributeKey() : new AttributeKey(this.attr);
            Field f = ReflectionUtil.resolveField(type, key);
            String string = ts = f != null ? ReflectionUtil.getTypeString(null, f) : null;
            if (f == null) {
                out.printf("Attributes for %s format:\n", regType.getEndpoint());
                LinkedHashMap<String, String> items = ReflectionUtil.getAttributeListWithJSonTypes(type, key);
                for (Map.Entry<String, String> item : items.entrySet()) {
                    out.printf("  %-40s %s\n", item.getKey(), item.getValue());
                }
            } else {
                out.printf("%-40s %s", this.attr, ts);
                boolean eol = false;
                Type t = f.getGenericType();
                if (ReflectionUtil.isListType(f.getType()) && t instanceof ParameterizedType) {
                    if (!ReflectionUtil.isBasicType(t = ((ParameterizedType)t).getActualTypeArguments()[0]) && t instanceof Class) {
                        eol = true;
                        System.out.printf(", where value is:\n", ts);
                        LinkedHashMap<String, String> items = ReflectionUtil.getAttributeListWithJSonTypes((Class)t, null);
                        for (Map.Entry<String, String> item : items.entrySet()) {
                            out.printf("    %-36s %s\n", item.getKey(), item.getValue());
                        }
                    }
                } else if (ReflectionUtil.isMapType(f.getType()) && t instanceof ParameterizedType && !ReflectionUtil.isBasicType(t = ((ParameterizedType)t).getActualTypeArguments()[1]) && t instanceof Class) {
                    eol = true;
                    out.printf(", where value is:\n", ts);
                    LinkedHashMap<String, String> items = ReflectionUtil.getAttributeListWithJSonTypes((Class)t, null);
                    for (Map.Entry<String, String> item : items.entrySet()) {
                        out.printf("    %-36s %s\n", item.getKey(), item.getValue());
                    }
                }
                if (!eol) {
                    out.println();
                }
            }
            CommandResult commandResult = CommandResult.SUCCESS;
            return commandResult;
        }
        finally {
            commandInvocation.stop();
        }
    }

    @Override
    protected String help() {
        return AttrsCmd.usage();
    }

    public static String usage() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Usage: " + OsUtil.CMD + " attrs [ATTRIBUTE] [ARGUMENTS]");
        out.println();
        out.println("List available configuration attributes.");
        out.println();
        out.println("Arguments:");
        out.println();
        out.println("  Global options:");
        out.println("    -x                   Print full stack trace when exiting with error");
        out.println();
        out.println("  Command specific options:");
        out.println("    ATTRIBUTE            Attribute key (if omitted all attributes for the endpoint type are listed)");
        out.println("                         Dot notation can be used to target sub-attributes.");
        out.println("    -e, --endpoint TYPE  Endpoint type to use - one of: 'default', 'oidc' (if omitted 'default' is used)");
        out.println();
        out.println("Examples:");
        out.println();
        out.println("List all attributes for default endpoint:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " attrs");
        out.println();
        out.println("List (sub)attributes of 'protocolMappers' attribute for default endpoint:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " attrs protocolMappers");
        out.println();
        out.println();
        out.println("Use '" + OsUtil.CMD + " help' for general information and a list of commands");
        return sb.toString();
    }
}

