/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console.command.container;

import org.jboss.aesh.cl.internal.ProcessedCommand;
import org.jboss.aesh.cl.parser.AeshCommandLineParser;
import org.jboss.aesh.cl.parser.CommandLineParser;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.container.CommandContainer;
import org.jboss.aesh.console.command.container.DefaultCommandContainer;

public class AeshCommandContainer<C extends Command>
extends DefaultCommandContainer<C> {
    private CommandLineParser<C> parser;
    private String errorMessage;

    public AeshCommandContainer(CommandLineParser parser) {
        if (parser != null && parser.getProcessedCommand() != null) {
            this.parser = parser;
        }
    }

    public AeshCommandContainer(ProcessedCommand<C> processedCommand) {
        this.parser = new AeshCommandLineParser<C>(processedCommand);
    }

    public AeshCommandContainer(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Override
    public CommandLineParser<C> getParser() {
        return this.parser;
    }

    @Override
    public boolean haveBuildError() {
        return this.errorMessage != null;
    }

    @Override
    public String getBuildErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void close() {
    }

    public void addChild(CommandContainer<?> commandContainer) {
        this.getParser().addChildParser(commandContainer.getParser());
    }

    public String toString() {
        return "AeshCommandContainer{parser=" + this.parser + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }
}

