/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration;

import java.io.IOException;
import org.apache.http.StatusLine;
import org.keycloak.representations.idm.OAuth2ErrorRepresentation;
import org.keycloak.util.JsonSerialization;

public class HttpErrorException
extends IOException {
    private final StatusLine statusLine;
    private final String errorResponse;

    public HttpErrorException(StatusLine statusLine, String errorResponse) {
        this.statusLine = statusLine;
        this.errorResponse = errorResponse;
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    public String getErrorResponse() {
        return this.errorResponse;
    }

    public OAuth2ErrorRepresentation toErrorRepresentation() {
        if (this.errorResponse == null) {
            return null;
        }
        try {
            return (OAuth2ErrorRepresentation)JsonSerialization.readValue((String)this.errorResponse, OAuth2ErrorRepresentation.class);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Not OAuth2 error");
        }
    }
}

