/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authorization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.AuthorizationContext;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.authentication.ClientCredentialsProviderUtils;
import org.keycloak.adapters.authorization.BearerTokenPolicyEnforcer;
import org.keycloak.adapters.authorization.KeycloakAdapterPolicyEnforcer;
import org.keycloak.adapters.authorization.PathMatcher;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.ClientAuthenticator;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.authorization.client.representation.ResourceRepresentation;
import org.keycloak.authorization.client.representation.ScopeRepresentation;
import org.keycloak.authorization.client.resource.ProtectedResource;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import org.keycloak.representations.idm.authorization.Permission;

public class PolicyEnforcer {
    private static Logger LOGGER = Logger.getLogger(PolicyEnforcer.class);
    private final KeycloakDeployment deployment;
    private final AuthzClient authzClient;
    private final PolicyEnforcerConfig enforcerConfig;
    private final Map<String, PolicyEnforcerConfig.PathConfig> paths;
    private final PathMatcher pathMatcher;

    public PolicyEnforcer(KeycloakDeployment deployment, AdapterConfig adapterConfig) {
        this.deployment = deployment;
        this.enforcerConfig = adapterConfig.getPolicyEnforcerConfig();
        Configuration configuration = new Configuration(adapterConfig.getAuthServerUrl(), adapterConfig.getRealm(), adapterConfig.getResource(), adapterConfig.getCredentials(), deployment.getClient());
        this.authzClient = AuthzClient.create((Configuration)configuration, (ClientAuthenticator)new ClientAuthenticator(){

            public void configureClientCredentials(Map<String, List<String>> requestParams, Map<String, String> requestHeaders) {
                HashMap<String, String> formparams = new HashMap<String, String>();
                ClientCredentialsProviderUtils.setClientCredentials(PolicyEnforcer.this.deployment, requestHeaders, formparams);
                for (Map.Entry param : formparams.entrySet()) {
                    requestParams.put((String)param.getKey(), Arrays.asList((String)param.getValue()));
                }
            }
        });
        this.pathMatcher = new PathMatcher(this.authzClient);
        this.paths = this.configurePaths(this.authzClient.protection().resource(), this.enforcerConfig);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Initialization complete. Path configurations:");
            for (PolicyEnforcerConfig.PathConfig pathConfig : this.paths.values()) {
                LOGGER.debug(pathConfig);
            }
        }
    }

    public AuthorizationContext enforce(OIDCHttpFacade facade) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debugv("Policy enforcement is enable. Enforcing policy decisions for path [{0}].", (Object)facade.getRequest().getURI());
        }
        AuthorizationContext context = this.deployment.isBearerOnly() ? new BearerTokenPolicyEnforcer(this).authorize(facade) : new KeycloakAdapterPolicyEnforcer(this).authorize(facade);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debugv("Policy enforcement result for path [{0}] is : {1}", (Object)facade.getRequest().getURI(), (Object)(context.isGranted() ? "GRANTED" : "DENIED"));
            LOGGER.debugv("Returning authorization context with permissions:", new Object[0]);
            for (Permission permission : context.getPermissions()) {
                LOGGER.debug(permission);
            }
        }
        return context;
    }

    PolicyEnforcerConfig getEnforcerConfig() {
        return this.enforcerConfig;
    }

    AuthzClient getClient() {
        return this.authzClient;
    }

    public Map<String, PolicyEnforcerConfig.PathConfig> getPaths() {
        return this.paths;
    }

    void addPath(PolicyEnforcerConfig.PathConfig pathConfig) {
        this.paths.put(pathConfig.getPath(), pathConfig);
    }

    KeycloakDeployment getDeployment() {
        return this.deployment;
    }

    private Map<String, PolicyEnforcerConfig.PathConfig> configurePaths(ProtectedResource protectedResource, PolicyEnforcerConfig enforcerConfig) {
        boolean loadPathsFromServer = true;
        for (PolicyEnforcerConfig.PathConfig pathConfig : enforcerConfig.getPaths()) {
            if (PolicyEnforcerConfig.EnforcementMode.DISABLED.equals((Object)pathConfig.getEnforcementMode())) continue;
            loadPathsFromServer = false;
            break;
        }
        if (loadPathsFromServer) {
            LOGGER.info("No path provided in configuration.");
            return this.configureAllPathsForResourceServer(protectedResource);
        }
        LOGGER.info("Paths provided in configuration.");
        return this.configureDefinedPaths(protectedResource, enforcerConfig);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, PolicyEnforcerConfig.PathConfig> configureDefinedPaths(ProtectedResource protectedResource, PolicyEnforcerConfig enforcerConfig) {
        Map<String, PolicyEnforcerConfig.PathConfig> paths = Collections.synchronizedMap(new HashMap());
        for (PolicyEnforcerConfig.PathConfig pathConfig : enforcerConfig.getPaths()) {
            ResourceRepresentation resource;
            String resourceName = pathConfig.getName();
            String path = pathConfig.getPath();
            if (resourceName != null) {
                LOGGER.debugf("Trying to find resource with name [%s] for path [%s].", (Object)resourceName, (Object)path);
                resource = protectedResource.findByName(resourceName);
            } else {
                LOGGER.debugf("Trying to find resource with uri [%s] for path [%s].", (Object)path, (Object)path);
                List resources = protectedResource.findByUri(path);
                if (resources.size() == 1) {
                    resource = (ResourceRepresentation)resources.get(0);
                } else {
                    if (resources.size() > 1) {
                        throw new RuntimeException("Multiple resources found with the same uri");
                    }
                    resource = null;
                }
            }
            if (resource == null) {
                if (!enforcerConfig.isCreateResources().booleanValue()) throw new RuntimeException("Could not find matching resource on server with uri [" + path + "] or name [" + resourceName + "]. Make sure you have created a resource on the server that matches with the path configuration.");
                LOGGER.debugf("Creating resource on server for path [%s].", (Object)pathConfig);
                ResourceRepresentation representation = new ResourceRepresentation();
                representation.setName(resourceName);
                representation.setType(pathConfig.getType());
                representation.setUri(path);
                HashSet<ScopeRepresentation> scopes = new HashSet<ScopeRepresentation>();
                for (String scopeName : pathConfig.getScopes()) {
                    ScopeRepresentation scope = new ScopeRepresentation();
                    scope.setName(scopeName);
                    scopes.add(scope);
                }
                representation.setScopes(scopes);
                ResourceRepresentation registrationResponse = protectedResource.create(representation);
                pathConfig.setId(registrationResponse.getId());
            } else {
                pathConfig.setId(resource.getId());
            }
            PolicyEnforcerConfig.PathConfig existingPath = null;
            for (PolicyEnforcerConfig.PathConfig current : paths.values()) {
                if (!current.getId().equals(pathConfig.getId()) || !current.getPath().equals(pathConfig.getPath())) continue;
                existingPath = current;
                break;
            }
            if (existingPath == null) {
                paths.put(pathConfig.getPath(), pathConfig);
                continue;
            }
            existingPath.getMethods().addAll(pathConfig.getMethods());
            existingPath.getScopes().addAll(pathConfig.getScopes());
        }
        return paths;
    }

    private Map<String, PolicyEnforcerConfig.PathConfig> configureAllPathsForResourceServer(ProtectedResource protectedResource) {
        LOGGER.info("Querying the server for all resources associated with this application.");
        Map<String, PolicyEnforcerConfig.PathConfig> paths = Collections.synchronizedMap(new HashMap());
        for (String id : protectedResource.findAll()) {
            ResourceRepresentation resourceDescription = protectedResource.findById(id);
            if (resourceDescription.getUri() == null) continue;
            PolicyEnforcerConfig.PathConfig pathConfig = PolicyEnforcer.createPathConfig(resourceDescription);
            paths.put(pathConfig.getPath(), pathConfig);
        }
        return paths;
    }

    static PolicyEnforcerConfig.PathConfig createPathConfig(ResourceRepresentation resourceDescription) {
        PolicyEnforcerConfig.PathConfig pathConfig = new PolicyEnforcerConfig.PathConfig();
        pathConfig.setId(resourceDescription.getId());
        pathConfig.setName(resourceDescription.getName());
        String uri = resourceDescription.getUri();
        if (uri == null || "".equals(uri.trim())) {
            throw new RuntimeException("Failed to configure paths. Resource [" + resourceDescription.getName() + "] has an invalid or empty URI [" + uri + "].");
        }
        pathConfig.setPath(uri);
        ArrayList<String> scopeNames = new ArrayList<String>();
        for (ScopeRepresentation scope : resourceDescription.getScopes()) {
            scopeNames.add(scope.getName());
        }
        pathConfig.setScopes(scopeNames);
        pathConfig.setType(resourceDescription.getType());
        return pathConfig;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }
}

