/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.installed;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.ServerRequest;
import org.keycloak.adapters.installed.KeycloakInstalled;
import org.keycloak.common.util.Time;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.util.JsonSerialization;

public class KeycloakCliSso {
    public void mainCmd(String[] args) throws Exception {
        if (args.length != 1) {
            this.printHelp();
            return;
        }
        if (args[0].equalsIgnoreCase("login")) {
            this.login();
        } else if (args[0].equalsIgnoreCase("login-manual")) {
            this.loginManual();
        } else if (args[0].equalsIgnoreCase("token")) {
            this.token();
        } else if (args[0].equalsIgnoreCase("logout")) {
            this.logout();
        } else if (args[0].equalsIgnoreCase("env")) {
            System.out.println(System.getenv().toString());
        } else {
            this.printHelp();
        }
    }

    public void printHelp() {
        System.err.println("Commands:");
        System.err.println("  login - login with desktop browser if available, otherwise do manual login.  Output is access token.");
        System.err.println("  login-manual - manual login");
        System.err.println("  token - print access token if logged in");
        System.err.println("  logout - logout.");
        System.exit(1);
    }

    public AdapterConfig getConfig() {
        String client;
        String realm;
        String url = System.getProperty("KEYCLOAK_AUTH_SERVER");
        if (url == null) {
            System.err.println("KEYCLOAK_AUTH_SERVER property not set");
            System.exit(1);
        }
        if ((realm = System.getProperty("KEYCLOAK_REALM")) == null) {
            System.err.println("KEYCLOAK_REALM property not set");
            System.exit(1);
        }
        if ((client = System.getProperty("KEYCLOAK_CLIENT")) == null) {
            System.err.println("KEYCLOAK_CLIENT property not set");
            System.exit(1);
        }
        String secret = System.getProperty("KEYCLOAK_CLIENT_SECRET");
        AdapterConfig config = new AdapterConfig();
        config.setAuthServerUrl(url);
        config.setRealm(realm);
        config.setResource(client);
        config.setSslRequired("external");
        if (secret != null) {
            HashMap<String, Object> creds = new HashMap<String, Object>();
            creds.put("secret", secret);
            config.setCredentials(creds);
        } else {
            config.setPublicClient(true);
        }
        return config;
    }

    public boolean checkToken() throws Exception {
        Matcher m;
        String token = this.getTokenResponse();
        if (token == null) {
            return false;
        }
        if (token != null && (m = Pattern.compile("\\{.*\\}\\z").matcher(token)).find()) {
            String json = m.group(0);
            try {
                AccessTokenResponse tokenResponse = JsonSerialization.readValue(json, AccessTokenResponse.class);
                if ((long)Time.currentTime() < tokenResponse.getExpiresIn()) {
                    return true;
                }
                AdapterConfig config = this.getConfig();
                KeycloakInstalled installed = new KeycloakInstalled(KeycloakDeploymentBuilder.build(config));
                installed.refreshToken(tokenResponse.getRefreshToken());
                this.processResponse(installed);
                return true;
            }
            catch (Exception e) {
                System.err.println("Error processing existing token");
                e.printStackTrace();
            }
        }
        return false;
    }

    private String getTokenResponse() throws IOException {
        String token = null;
        File tokenFile = this.getTokenFilePath();
        if (tokenFile.exists()) {
            FileInputStream fis = new FileInputStream(tokenFile);
            byte[] data = new byte[(int)tokenFile.length()];
            fis.read(data);
            fis.close();
            token = new String(data, "UTF-8");
        }
        return token;
    }

    public void token() throws Exception {
        String token = this.getTokenResponse();
        if (token == null) {
            System.err.println("There is no token for client");
            System.exit(1);
        } else {
            Matcher m = Pattern.compile("\\{.*\\}\\z").matcher(token);
            if (m.find()) {
                String json = m.group(0);
                try {
                    AccessTokenResponse tokenResponse = JsonSerialization.readValue(json, AccessTokenResponse.class);
                    if ((long)Time.currentTime() < tokenResponse.getExpiresIn()) {
                        System.out.println(tokenResponse.getToken());
                        return;
                    }
                    System.err.println("token in response file is expired");
                    System.exit(1);
                }
                catch (Exception e) {
                    System.err.println("Failure processing token response file");
                    e.printStackTrace();
                    System.exit(1);
                }
            } else {
                System.err.println("Could not find json within token response file");
                System.exit(1);
            }
        }
    }

    public void login() throws Exception {
        if (this.checkToken()) {
            return;
        }
        AdapterConfig config = this.getConfig();
        KeycloakInstalled installed = new KeycloakInstalled(KeycloakDeploymentBuilder.build(config));
        installed.login();
        this.processResponse(installed);
    }

    public String getHome() {
        String home = System.getenv("HOME");
        if (home == null && (home = System.getProperty("HOME")) == null) {
            home = Paths.get("", new String[0]).toAbsolutePath().normalize().toString();
        }
        return home;
    }

    public File getTokenDirectory() {
        return Paths.get(this.getHome(), System.getProperty("basepath", ".keycloak-sso"), System.getProperty("KEYCLOAK_REALM")).toFile();
    }

    public File getTokenFilePath() {
        return Paths.get(this.getHome(), System.getProperty("basepath", ".keycloak-sso"), System.getProperty("KEYCLOAK_REALM"), System.getProperty("KEYCLOAK_CLIENT") + ".json").toFile();
    }

    private void processResponse(KeycloakInstalled installed) throws IOException {
        AccessTokenResponse tokenResponse = installed.getTokenResponse();
        tokenResponse.setExpiresIn((long)Time.currentTime() + tokenResponse.getExpiresIn());
        tokenResponse.setIdToken(null);
        String output = JsonSerialization.writeValueAsString(tokenResponse);
        this.getTokenDirectory().mkdirs();
        FileOutputStream fos = new FileOutputStream(this.getTokenFilePath());
        fos.write(output.getBytes("UTF-8"));
        fos.flush();
        fos.close();
        System.out.println(tokenResponse.getToken());
    }

    public void loginManual() throws Exception {
        if (this.checkToken()) {
            return;
        }
        AdapterConfig config = this.getConfig();
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build(config);
        KeycloakInstalled installed = new KeycloakInstalled(deployment);
        installed.loginManual();
        this.processResponse(installed);
    }

    public void logout() throws Exception {
        String token = this.getTokenResponse();
        if (token != null) {
            Matcher m = Pattern.compile("\\{.*\\}\\z").matcher(token);
            if (m.find()) {
                String json = m.group(0);
                try {
                    AccessTokenResponse tokenResponse = JsonSerialization.readValue(json, AccessTokenResponse.class);
                    if ((long)Time.currentTime() > tokenResponse.getExpiresIn()) {
                        System.err.println("Login is expired");
                        System.exit(1);
                    }
                    AdapterConfig config = this.getConfig();
                    KeycloakDeployment deployment = KeycloakDeploymentBuilder.build(config);
                    ServerRequest.invokeLogout(deployment, tokenResponse.getRefreshToken());
                    for (File fp : this.getTokenDirectory().listFiles()) {
                        fp.delete();
                    }
                    System.out.println("logout complete");
                }
                catch (Exception e) {
                    System.err.println("Failure processing token response file");
                    e.printStackTrace();
                    System.exit(1);
                }
            } else {
                System.err.println("Could not find json within token response file");
                System.exit(1);
            }
        } else {
            System.err.println("Not logged in");
            System.exit(1);
        }
    }
}

