/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.as7;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.metadata.web.jboss.JBossWebMetaData;

public final class KeycloakAdapterConfigService {
    protected Logger log = Logger.getLogger(KeycloakAdapterConfigService.class);
    private static final String CREDENTIALS_JSON_NAME = "credentials";
    private static final KeycloakAdapterConfigService INSTANCE = new KeycloakAdapterConfigService();
    private final Map<String, ModelNode> realms = new HashMap<String, ModelNode>();
    private final Map<String, ModelNode> secureDeployments = new HashMap<String, ModelNode>();

    public static KeycloakAdapterConfigService getInstance() {
        return INSTANCE;
    }

    private KeycloakAdapterConfigService() {
    }

    public void addRealm(ModelNode operation, ModelNode model) {
        this.realms.put(this.realmNameFromOp(operation), model.clone());
    }

    public void updateRealm(ModelNode operation, String attrName, ModelNode resolvedValue) {
        ModelNode realm = this.realms.get(this.realmNameFromOp(operation));
        realm.get(attrName).set(resolvedValue);
    }

    public void removeRealm(ModelNode operation) {
        this.realms.remove(this.realmNameFromOp(operation));
    }

    public void addSecureDeployment(ModelNode operation, ModelNode model) {
        ModelNode deployment = model.clone();
        this.secureDeployments.put(this.deploymentNameFromOp(operation), deployment);
    }

    public void updateSecureDeployment(ModelNode operation, String attrName, ModelNode resolvedValue) {
        ModelNode deployment = this.secureDeployments.get(this.deploymentNameFromOp(operation));
        deployment.get(attrName).set(resolvedValue);
    }

    public void removeSecureDeployment(ModelNode operation) {
        this.secureDeployments.remove(this.deploymentNameFromOp(operation));
    }

    public void addCredential(ModelNode operation, ModelNode model) {
        String credentialName;
        ModelNode credentials = this.credentialsFromOp(operation);
        if (!credentials.isDefined()) {
            credentials = new ModelNode();
        }
        if (!(credentialName = this.credentialNameFromOp(operation)).contains(".")) {
            credentials.get(credentialName).set(model.get("value").asString());
        } else {
            String[] parts = credentialName.split("\\.");
            String provider = parts[0];
            String property = parts[1];
            ModelNode credential = credentials.get(provider);
            if (!credential.isDefined()) {
                credential = new ModelNode();
            }
            credential.get(property).set(model.get("value").asString());
            credentials.set(provider, credential);
        }
        ModelNode deployment = this.secureDeployments.get(this.deploymentNameFromOp(operation));
        deployment.get(CREDENTIALS_JSON_NAME).set(credentials);
    }

    public void removeCredential(ModelNode operation) {
        ModelNode credentials = this.credentialsFromOp(operation);
        if (!credentials.isDefined()) {
            throw new RuntimeException("Can not remove credential.  No credential defined for deployment in op " + operation.toString());
        }
        String credentialName = this.credentialNameFromOp(operation);
        credentials.remove(credentialName);
    }

    public void updateCredential(ModelNode operation, String attrName, ModelNode resolvedValue) {
        ModelNode credentials = this.credentialsFromOp(operation);
        if (!credentials.isDefined()) {
            throw new RuntimeException("Can not update credential.  No credential defined for deployment in op " + operation.toString());
        }
        String credentialName = this.credentialNameFromOp(operation);
        credentials.get(credentialName).set(resolvedValue);
    }

    private ModelNode credentialsFromOp(ModelNode operation) {
        ModelNode deployment = this.secureDeployments.get(this.deploymentNameFromOp(operation));
        return deployment.get(CREDENTIALS_JSON_NAME);
    }

    private String realmNameFromOp(ModelNode operation) {
        return this.valueFromOpAddress("realm", operation);
    }

    private String deploymentNameFromOp(ModelNode operation) {
        return this.valueFromOpAddress("secure-deployment", operation);
    }

    private String credentialNameFromOp(ModelNode operation) {
        return this.valueFromOpAddress("credential", operation);
    }

    private String valueFromOpAddress(String addrElement, ModelNode operation) {
        String deploymentName = this.getValueOfAddrElement(operation.get("address"), addrElement);
        if (deploymentName == null) {
            throw new RuntimeException("Can't find '" + addrElement + "' in address " + operation.toString());
        }
        return deploymentName;
    }

    private String getValueOfAddrElement(ModelNode address, String elementName) {
        for (ModelNode element : address.asList()) {
            if (!element.has(elementName)) continue;
            return element.get(elementName).asString();
        }
        return null;
    }

    public String getRealmName(DeploymentUnit deploymentUnit) {
        String deploymentName = this.preferredDeploymentName(deploymentUnit);
        ModelNode deployment = this.secureDeployments.get(deploymentName);
        return deployment.get("realm").asString();
    }

    public String getJSON(DeploymentUnit deploymentUnit) {
        String deploymentName = this.preferredDeploymentName(deploymentUnit);
        ModelNode deployment = this.secureDeployments.get(deploymentName);
        String realmName = deployment.get("realm").asString();
        ModelNode realm = this.realms.get(realmName);
        ModelNode json = new ModelNode();
        json.get("realm").set(realmName);
        if (realm != null) {
            this.setJSONValues(json, realm);
        }
        this.setJSONValues(json, deployment);
        return json.toJSONString(true);
    }

    private void setJSONValues(ModelNode json, ModelNode values) {
        for (Property prop : values.asPropertyList()) {
            String name = prop.getName();
            ModelNode value = prop.getValue();
            if (!value.isDefined()) continue;
            json.get(name).set(value);
        }
    }

    public boolean isSecureDeployment(DeploymentUnit deploymentUnit) {
        String deploymentName = this.preferredDeploymentName(deploymentUnit);
        return this.secureDeployments.containsKey(deploymentName);
    }

    private String preferredDeploymentName(DeploymentUnit deploymentUnit) {
        String deploymentName = deploymentUnit.getName();
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            return deploymentName;
        }
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            return deploymentName;
        }
        String moduleName = webMetaData.getModuleName();
        if (moduleName != null) {
            return moduleName + ".war";
        }
        return deploymentName;
    }
}

