/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.idm;

import java.util.Objects;
import org.keycloak.common.util.ObjectUtil;

public class LDAPCapabilityRepresentation {
    private Object oid;
    private CapabilityType type;

    public LDAPCapabilityRepresentation() {
    }

    public LDAPCapabilityRepresentation(Object oidValue, CapabilityType type) {
        this.oid = Objects.requireNonNull(oidValue);
        this.type = type;
    }

    public String getOid() {
        return this.oid instanceof String ? (String)this.oid : String.valueOf(this.oid);
    }

    public CapabilityType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LDAPCapabilityRepresentation ldapOid = (LDAPCapabilityRepresentation)o;
        return ObjectUtil.isEqualOrBothNull(this.oid, ldapOid.oid) && ObjectUtil.isEqualOrBothNull((Object)this.type, (Object)ldapOid.type);
    }

    public int hashCode() {
        return this.oid.hashCode();
    }

    public String toString() {
        return LDAPCapabilityRepresentation.class.getSimpleName() + "[ " + ("oid=" + this.oid + ", ") + ("type=" + this.type + " ]");
    }

    public static enum CapabilityType {
        CONTROL,
        EXTENSION,
        FEATURE,
        UNKNOWN;


        public static CapabilityType fromRootDseAttributeName(String attributeName) {
            switch (attributeName) {
                case "supportedExtension": {
                    return EXTENSION;
                }
                case "supportedControl": {
                    return CONTROL;
                }
                case "supportedFeatures": {
                    return FEATURE;
                }
            }
            return UNKNOWN;
        }
    }
}

