/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.client.token;

import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.keycloak.admin.client.Config;
import org.keycloak.admin.client.resource.BasicAuthFilter;
import org.keycloak.admin.client.token.TokenService;
import org.keycloak.common.util.Time;
import org.keycloak.representations.AccessTokenResponse;

public class TokenManager {
    private static final long DEFAULT_MIN_VALIDITY = 30L;
    private AccessTokenResponse currentToken;
    private long expirationTime;
    private long minTokenValidity = 30L;
    private final Config config;
    private final ResteasyClient client;

    public TokenManager(Config config, ResteasyClient client) {
        this.config = config;
        this.client = client;
    }

    public String getAccessTokenString() {
        return this.getAccessToken().getToken();
    }

    public AccessTokenResponse getAccessToken() {
        if (this.currentToken == null) {
            this.grantToken();
        } else if (this.tokenExpired()) {
            this.refreshToken();
        }
        return this.currentToken;
    }

    public AccessTokenResponse grantToken() {
        ResteasyWebTarget target = this.client.target(this.config.getServerUrl());
        Form form = new Form().param("grant_type", "password").param("username", this.config.getUsername()).param("password", this.config.getPassword());
        if (this.config.isPublicClient()) {
            form.param("client_id", this.config.getClientId());
        } else {
            target.register((Object)new BasicAuthFilter(this.config.getClientId(), this.config.getClientSecret()));
        }
        TokenService tokenService = (TokenService)target.proxy(TokenService.class);
        int requestTime = Time.currentTime();
        this.currentToken = tokenService.grantToken(this.config.getRealm(), (MultivaluedMap<String, String>)form.asMap());
        this.expirationTime = (long)requestTime + this.currentToken.getExpiresIn();
        return this.currentToken;
    }

    public AccessTokenResponse refreshToken() {
        ResteasyWebTarget target = this.client.target(this.config.getServerUrl());
        Form form = new Form().param("grant_type", "refresh_token").param("refresh_token", this.currentToken.getRefreshToken());
        if (this.config.isPublicClient()) {
            form.param("client_id", this.config.getClientId());
        } else {
            target.register((Object)new BasicAuthFilter(this.config.getClientId(), this.config.getClientSecret()));
        }
        TokenService tokenService = (TokenService)target.proxy(TokenService.class);
        try {
            int requestTime = Time.currentTime();
            this.currentToken = tokenService.refreshToken(this.config.getRealm(), (MultivaluedMap<String, String>)form.asMap());
            this.expirationTime = (long)requestTime + this.currentToken.getExpiresIn();
            return this.currentToken;
        }
        catch (BadRequestException e) {
            return this.grantToken();
        }
    }

    public void setMinTokenValidity(long minTokenValidity) {
        this.minTokenValidity = minTokenValidity;
    }

    private boolean tokenExpired() {
        return (long)Time.currentTime() + this.minTokenValidity >= this.expirationTime;
    }
}

