/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.client;

import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.keycloak.admin.client.Keycloak;

public class KeycloakBuilder {
    private String serverUrl;
    private String realm;
    private String username;
    private String password;
    private String clientId;
    private String clientSecret;
    private ResteasyClient resteasyClient;

    public KeycloakBuilder serverUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this;
    }

    public KeycloakBuilder realm(String realm) {
        this.realm = realm;
        return this;
    }

    public KeycloakBuilder username(String username) {
        this.username = username;
        return this;
    }

    public KeycloakBuilder password(String password) {
        this.password = password;
        return this;
    }

    public KeycloakBuilder clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public KeycloakBuilder clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public KeycloakBuilder resteasyClient(ResteasyClient resteasyClient) {
        this.resteasyClient = resteasyClient;
        return this;
    }

    public Keycloak build() {
        if (this.serverUrl == null) {
            throw new IllegalStateException("serverUrl required");
        }
        if (this.realm == null) {
            throw new IllegalStateException("realm required");
        }
        if (this.username == null) {
            throw new IllegalStateException("username required");
        }
        if (this.password == null) {
            throw new IllegalStateException("password required");
        }
        if (this.clientId == null) {
            throw new IllegalStateException("clientId required");
        }
        return new Keycloak(this.serverUrl, this.realm, this.username, this.password, this.clientId, this.clientSecret, this.resteasyClient);
    }

    private KeycloakBuilder() {
    }

    public static KeycloakBuilder builder() {
        return new KeycloakBuilder();
    }
}

