/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.client.resource;

import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.keycloak.admin.client.resource.RoleMappingResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.representations.idm.ApplicationRepresentation;
import org.keycloak.representations.idm.ClaimRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;

public interface ApplicationResource {
    @GET
    @Produces(value={"application/json"})
    public ApplicationRepresentation toRepresentation();

    @PUT
    @Consumes(value={"application/json"})
    public void update(ApplicationRepresentation var1);

    @DELETE
    public void remove();

    @GET
    @Path(value="allowed-origins")
    @Produces(value={"application/json"})
    public Set<String> getAllowedOrigins();

    @PUT
    @Path(value="allowed-origins")
    @Consumes(value={"application/json"})
    public void updateAllowedOrigins(Set<String> var1);

    @DELETE
    @Path(value="allowed-origins")
    @Consumes(value={"application/json"})
    public void removeAllowedOrigins(Set<String> var1);

    @GET
    @Path(value="claims")
    @Produces(value={"application/json"})
    public ClaimRepresentation getClaims();

    @PUT
    @Path(value="claims")
    @Consumes(value={"application/json"})
    public void updateClaims(ClaimRepresentation var1);

    @POST
    @Path(value="client-secret")
    @Produces(value={"application/json"})
    public CredentialRepresentation generateNewSecret();

    @GET
    @Path(value="client-secret")
    @Produces(value={"application/json"})
    public CredentialRepresentation getSecret();

    @GET
    @Path(value="installation/jboss")
    @Produces(value={"application/xml"})
    public String getInstallationJbossXml();

    @GET
    @Path(value="installation/json")
    @Produces(value={"application/json"})
    public String getInstallationJson();

    @POST
    @Path(value="logout-all")
    public void logoutAllUsers();

    @POST
    @Path(value="logout-user/{username}")
    public void logoutUser(@PathParam(value="username") String var1);

    @POST
    @Path(value="push-revocation")
    public void pushRevocation();

    @Path(value="/scope-mappings")
    public RoleMappingResource getScopeMappings();

    @Path(value="/roles")
    public RolesResource roles();
}

