/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.rotation;

import java.security.PublicKey;
import org.jboss.logging.Logger;
import org.keycloak.RSATokenVerifier;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.rotation.PublicKeyLocator;
import org.keycloak.common.VerificationException;
import org.keycloak.representations.AccessToken;

public class AdapterRSATokenVerifier {
    private static final Logger log = Logger.getLogger(AdapterRSATokenVerifier.class);

    public static AccessToken verifyToken(String tokenString, KeycloakDeployment deployment) throws VerificationException {
        return AdapterRSATokenVerifier.verifyToken(tokenString, deployment, true, true);
    }

    public static PublicKey getPublicKey(String kid, KeycloakDeployment deployment) throws VerificationException {
        PublicKeyLocator pkLocator = deployment.getPublicKeyLocator();
        PublicKey publicKey = pkLocator.getPublicKey(kid, deployment);
        if (publicKey == null) {
            log.errorf("Didn't find publicKey for kid: %s", (Object)kid);
            throw new VerificationException("Didn't find publicKey for specified kid");
        }
        return publicKey;
    }

    public static AccessToken verifyToken(String tokenString, KeycloakDeployment deployment, boolean checkActive, boolean checkTokenType) throws VerificationException {
        RSATokenVerifier verifier = RSATokenVerifier.create((String)tokenString).realmUrl(deployment.getRealmInfoUrl()).checkActive(checkActive).checkTokenType(checkTokenType);
        PublicKey publicKey = AdapterRSATokenVerifier.getPublicKey(verifier.getHeader().getKeyId(), deployment);
        return verifier.publicKey(publicKey).verify().getToken();
    }
}

