/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authorization;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.AuthorizationContext;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.authorization.BearerTokenPolicyEnforcer;
import org.keycloak.adapters.authorization.KeycloakAdapterPolicyEnforcer;
import org.keycloak.adapters.authorization.PathMatcher;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.authorization.client.representation.RegistrationResponse;
import org.keycloak.authorization.client.representation.ResourceRepresentation;
import org.keycloak.authorization.client.representation.ScopeRepresentation;
import org.keycloak.authorization.client.resource.ProtectedResource;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import org.keycloak.representations.authorization.Permission;

public class PolicyEnforcer {
    private static Logger LOGGER = Logger.getLogger(PolicyEnforcer.class);
    private final KeycloakDeployment deployment;
    private final PathMatcher pathMatcher;
    private final AuthzClient authzClient;
    private final PolicyEnforcerConfig enforcerConfig;
    private final List<PolicyEnforcerConfig.PathConfig> paths;

    public PolicyEnforcer(KeycloakDeployment deployment, AdapterConfig adapterConfig) {
        this.deployment = deployment;
        this.enforcerConfig = adapterConfig.getPolicyEnforcerConfig();
        this.authzClient = AuthzClient.create((Configuration)new Configuration(adapterConfig.getAuthServerUrl(), adapterConfig.getRealm(), adapterConfig.getResource(), adapterConfig.getCredentials(), deployment.getClient()));
        this.pathMatcher = new PathMatcher();
        this.paths = this.configurePaths(this.authzClient.protection().resource(), this.enforcerConfig);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Initialization complete. Path configurations:");
            for (PolicyEnforcerConfig.PathConfig pathConfig : this.paths) {
                LOGGER.debug((Object)pathConfig);
            }
        }
    }

    public AuthorizationContext enforce(OIDCHttpFacade facade) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debugv("Policy enforcement is enable. Enforcing policy decisions for path [{0}].", (Object)facade.getRequest().getURI());
        }
        AuthorizationContext context = this.deployment.isBearerOnly() ? new BearerTokenPolicyEnforcer(this).authorize(facade) : new KeycloakAdapterPolicyEnforcer(this).authorize(facade);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debugv("Policy enforcement result for path [{0}] is : {1}", (Object)facade.getRequest().getURI(), (Object)(context.isGranted() ? "GRANTED" : "DENIED"));
            LOGGER.debugv("Returning authorization context with permissions:", new Object[0]);
            for (Permission permission : context.getPermissions()) {
                LOGGER.debug((Object)permission);
            }
        }
        return context;
    }

    PolicyEnforcerConfig getEnforcerConfig() {
        return this.enforcerConfig;
    }

    AuthzClient getClient() {
        return this.authzClient;
    }

    List<PolicyEnforcerConfig.PathConfig> getPaths() {
        return this.paths;
    }

    KeycloakDeployment getDeployment() {
        return this.deployment;
    }

    private List<PolicyEnforcerConfig.PathConfig> configurePaths(ProtectedResource protectedResource, PolicyEnforcerConfig enforcerConfig) {
        if (enforcerConfig.getPaths().isEmpty()) {
            LOGGER.info((Object)"No path provided in configuration.");
            return this.configureAllPathsForResourceServer(protectedResource);
        }
        LOGGER.info((Object)"Paths provided in configuration.");
        return this.configureDefinedPaths(protectedResource, enforcerConfig);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<PolicyEnforcerConfig.PathConfig> configureDefinedPaths(ProtectedResource protectedResource, PolicyEnforcerConfig enforcerConfig) {
        ArrayList<PolicyEnforcerConfig.PathConfig> paths = new ArrayList<PolicyEnforcerConfig.PathConfig>();
        for (PolicyEnforcerConfig.PathConfig pathConfig : enforcerConfig.getPaths()) {
            Set search;
            String resourceName = pathConfig.getName();
            String path = pathConfig.getPath();
            if (resourceName != null) {
                LOGGER.debugf("Trying to find resource with name [%s] for path [%s].", (Object)resourceName, (Object)path);
                search = protectedResource.findByFilter("name=" + resourceName);
            } else {
                LOGGER.debugf("Trying to find resource with uri [%s] for path [%s].", (Object)path, (Object)path);
                search = protectedResource.findByFilter("uri=" + path);
            }
            if (search.isEmpty()) {
                if (!enforcerConfig.isCreateResources().booleanValue()) throw new RuntimeException("Could not find matching resource on server with uri [" + path + "] or name [" + resourceName + ". Make sure you have created a resource on the server that matches with the path configuration.");
                LOGGER.debugf("Creating resource on server for path [%s].", (Object)pathConfig);
                ResourceRepresentation resource = new ResourceRepresentation();
                resource.setName(resourceName);
                resource.setType(pathConfig.getType());
                resource.setUri(path);
                HashSet<ScopeRepresentation> scopes = new HashSet<ScopeRepresentation>();
                for (String scopeName : pathConfig.getScopes()) {
                    ScopeRepresentation scope = new ScopeRepresentation();
                    scope.setName(scopeName);
                    scopes.add(scope);
                }
                resource.setScopes(scopes);
                RegistrationResponse registrationResponse = protectedResource.create(resource);
                pathConfig.setId(registrationResponse.getId());
            } else {
                pathConfig.setId((String)search.iterator().next());
            }
            paths.add(pathConfig);
        }
        return paths;
    }

    private List<PolicyEnforcerConfig.PathConfig> configureAllPathsForResourceServer(ProtectedResource protectedResource) {
        LOGGER.info((Object)"Querying the server for all resources associated with this application.");
        ArrayList<PolicyEnforcerConfig.PathConfig> paths = new ArrayList<PolicyEnforcerConfig.PathConfig>();
        for (String id : protectedResource.findAll()) {
            RegistrationResponse response = protectedResource.findById(id);
            ResourceRepresentation resourceDescription = response.getResourceDescription();
            if (resourceDescription.getUri() == null) continue;
            paths.add(this.createPathConfig(resourceDescription));
        }
        return paths;
    }

    private PolicyEnforcerConfig.PathConfig createPathConfig(ResourceRepresentation resourceDescription) {
        PolicyEnforcerConfig.PathConfig pathConfig = new PolicyEnforcerConfig.PathConfig();
        pathConfig.setId(resourceDescription.getId());
        pathConfig.setName(resourceDescription.getName());
        pathConfig.setPath(resourceDescription.getUri());
        ArrayList<String> scopeNames = new ArrayList<String>();
        for (ScopeRepresentation scope : resourceDescription.getScopes()) {
            scopeNames.add(scope.getName());
        }
        pathConfig.setScopes(scopeNames);
        pathConfig.setType(resourceDescription.getType());
        return pathConfig;
    }
}

