/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authorization;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.AuthorizationContext;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.authorization.PathMatcher;
import org.keycloak.adapters.authorization.PolicyEnforcer;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.representation.ResourceRepresentation;
import org.keycloak.authorization.client.resource.ProtectedResource;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import org.keycloak.representations.authorization.Permission;

public abstract class AbstractPolicyEnforcer {
    private static Logger LOGGER = Logger.getLogger(AbstractPolicyEnforcer.class);
    private final PolicyEnforcerConfig enforcerConfig;
    private final PolicyEnforcer policyEnforcer;
    private List<PolicyEnforcerConfig.PathConfig> paths;
    private AuthzClient authzClient;
    private PathMatcher pathMatcher;

    public AbstractPolicyEnforcer(PolicyEnforcer policyEnforcer) {
        this.policyEnforcer = policyEnforcer;
        this.enforcerConfig = policyEnforcer.getEnforcerConfig();
        this.authzClient = policyEnforcer.getClient();
        this.pathMatcher = new PathMatcher();
        this.paths = policyEnforcer.getPaths();
    }

    public AuthorizationContext authorize(OIDCHttpFacade httpFacade) {
        Set<String> requiredScopes;
        PolicyEnforcerConfig.EnforcementMode enforcementMode = this.enforcerConfig.getEnforcementMode();
        if (PolicyEnforcerConfig.EnforcementMode.DISABLED.equals((Object)enforcementMode)) {
            return this.createEmptyAuthorizationContext(true);
        }
        AccessToken accessToken = httpFacade.getSecurityContext().getToken();
        HttpFacade.Request request = httpFacade.getRequest();
        HttpFacade.Response response = httpFacade.getResponse();
        String pathInfo = URI.create(request.getURI()).getPath().substring(1);
        String path = pathInfo.substring(pathInfo.indexOf(47), pathInfo.length());
        PolicyEnforcerConfig.PathConfig pathConfig = this.pathMatcher.matches(path, this.paths);
        LOGGER.debugf("Checking permissions for path [%s] with config [%s].", (Object)request.getURI(), (Object)pathConfig);
        if (pathConfig == null) {
            if (PolicyEnforcerConfig.EnforcementMode.PERMISSIVE.equals((Object)enforcementMode)) {
                return this.createAuthorizationContext(accessToken);
            }
            LOGGER.debugf("Could not find a configuration for path [%s]", (Object)path);
            response.sendError(403, "Could not find a configuration for path [" + path + "].");
            return this.createEmptyAuthorizationContext(false);
        }
        PolicyEnforcerConfig.PathConfig actualPathConfig = this.resolvePathConfig(pathConfig, request);
        if (this.isAuthorized(actualPathConfig, requiredScopes = this.getRequiredScopes(actualPathConfig, request), accessToken, httpFacade)) {
            try {
                return this.createAuthorizationContext(accessToken);
            }
            catch (Exception e) {
                throw new RuntimeException("Error processing path [" + actualPathConfig.getPath() + "].", e);
            }
        }
        if (!this.challenge(actualPathConfig, requiredScopes, httpFacade)) {
            LOGGER.debugf("Sending challenge to the client. Path [%s]", (Object)pathConfig);
            response.sendError(403, "Authorization failed.");
        }
        return this.createEmptyAuthorizationContext(false);
    }

    protected abstract boolean challenge(PolicyEnforcerConfig.PathConfig var1, Set<String> var2, OIDCHttpFacade var3);

    protected boolean isAuthorized(PolicyEnforcerConfig.PathConfig actualPathConfig, Set<String> requiredScopes, AccessToken accessToken, OIDCHttpFacade httpFacade) {
        HttpFacade.Request request = httpFacade.getRequest();
        PolicyEnforcerConfig enforcerConfig = this.getEnforcerConfig();
        String accessDeniedPath = enforcerConfig.getAccessDeniedPath();
        if (accessDeniedPath != null && request.getURI().contains(accessDeniedPath)) {
            return true;
        }
        AccessToken.Authorization authorization = accessToken.getAuthorization();
        if (authorization == null) {
            return false;
        }
        List permissions = authorization.getPermissions();
        for (Permission permission : permissions) {
            Set allowedScopes = permission.getScopes();
            if (permission.getResourceSetId() != null) {
                if (!this.isResourcePermission(actualPathConfig, permission) || (allowedScopes != null && !allowedScopes.isEmpty() || !requiredScopes.isEmpty()) && !allowedScopes.containsAll(requiredScopes)) continue;
                LOGGER.debugf("Authorization GRANTED for path [%s]. Permissions [%s].", (Object)actualPathConfig, (Object)permissions);
                if (request.getMethod().equalsIgnoreCase("DELETE") && actualPathConfig.isInstance()) {
                    this.paths.remove(actualPathConfig);
                }
                return true;
            }
            if ((!allowedScopes.isEmpty() || !requiredScopes.isEmpty()) && !allowedScopes.containsAll(requiredScopes)) continue;
            LOGGER.debugf("Authorization GRANTED for path [%s]. Permissions [%s].", (Object)actualPathConfig, (Object)permissions);
            return true;
        }
        LOGGER.debugf("Authorization FAILED for path [%s]. No enough permissions [%s].", (Object)actualPathConfig, (Object)permissions);
        return false;
    }

    protected AuthzClient getAuthzClient() {
        return this.authzClient;
    }

    protected PolicyEnforcerConfig getEnforcerConfig() {
        return this.enforcerConfig;
    }

    protected PolicyEnforcer getPolicyEnforcer() {
        return this.policyEnforcer;
    }

    private AuthorizationContext createEmptyAuthorizationContext(final boolean granted) {
        return new AuthorizationContext(){

            public boolean hasPermission(String resourceName, String scopeName) {
                return granted;
            }

            public boolean hasResourcePermission(String resourceName) {
                return granted;
            }

            public boolean hasScopePermission(String scopeName) {
                return granted;
            }

            public List<Permission> getPermissions() {
                return Collections.EMPTY_LIST;
            }

            public boolean isGranted() {
                return granted;
            }
        };
    }

    private PolicyEnforcerConfig.PathConfig resolvePathConfig(PolicyEnforcerConfig.PathConfig originalConfig, HttpFacade.Request request) {
        if (originalConfig.hasPattern()) {
            String pathInfo = URI.create(request.getURI()).getPath().substring(1);
            String path = pathInfo.substring(pathInfo.indexOf(47), pathInfo.length());
            ProtectedResource resource = this.authzClient.protection().resource();
            Set search = resource.findByFilter("uri=" + path);
            if (!search.isEmpty()) {
                ResourceRepresentation targetResource = resource.findById((String)search.iterator().next()).getResourceDescription();
                PolicyEnforcerConfig.PathConfig config = new PolicyEnforcerConfig.PathConfig();
                config.setId(targetResource.getId());
                config.setName(targetResource.getName());
                config.setType(targetResource.getType());
                config.setPath(targetResource.getUri());
                config.setScopes(originalConfig.getScopes());
                config.setMethods(originalConfig.getMethods());
                config.setInstance(true);
                config.setParentConfig(originalConfig);
                this.paths.add(config);
                return config;
            }
        }
        return originalConfig;
    }

    private Set<String> getRequiredScopes(PolicyEnforcerConfig.PathConfig pathConfig, HttpFacade.Request request) {
        HashSet<String> requiredScopes = new HashSet<String>();
        requiredScopes.addAll(pathConfig.getScopes());
        String method = request.getMethod();
        for (PolicyEnforcerConfig.MethodConfig methodConfig : pathConfig.getMethods()) {
            if (!methodConfig.getMethod().equals(method)) continue;
            requiredScopes.addAll(methodConfig.getScopes());
        }
        return requiredScopes;
    }

    private AuthorizationContext createAuthorizationContext(AccessToken accessToken) {
        return new AuthorizationContext(accessToken, this.paths);
    }

    private boolean isResourcePermission(PolicyEnforcerConfig.PathConfig actualPathConfig, Permission permission) {
        boolean resourceMatch = permission.getResourceSetId().equals(actualPathConfig.getId());
        if (!resourceMatch && actualPathConfig.isInstance()) {
            resourceMatch = permission.getResourceSetId().equals(actualPathConfig.getParentConfig().getId());
        }
        return resourceMatch;
    }
}

