/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters;

import java.net.URI;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.jboss.logging.Logger;
import org.keycloak.adapters.authentication.ClientCredentialsProvider;
import org.keycloak.common.enums.RelativeUrlsUsed;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.enums.TokenStore;
import org.keycloak.representations.adapters.config.AdapterConfig;

public class KeycloakDeployment {
    private static final Logger log = Logger.getLogger(KeycloakDeployment.class);
    protected RelativeUrlsUsed relativeUrls;
    protected String realm;
    protected volatile PublicKey realmKey;
    protected String authServerBaseUrl;
    protected String realmInfoUrl;
    protected KeycloakUriBuilder authUrl;
    protected String tokenUrl;
    protected KeycloakUriBuilder logoutUrl;
    protected String accountUrl;
    protected String registerNodeUrl;
    protected String unregisterNodeUrl;
    protected String principalAttribute = "sub";
    protected String resourceName;
    protected boolean bearerOnly;
    protected boolean enableBasicAuth;
    protected boolean publicClient;
    protected Map<String, Object> resourceCredentials = new HashMap<String, Object>();
    protected ClientCredentialsProvider clientAuthenticator;
    protected HttpClient client;
    protected String scope;
    protected SslRequired sslRequired = SslRequired.ALL;
    protected TokenStore tokenStore = TokenStore.SESSION;
    protected String stateCookieName = "OAuth_Token_Request_State";
    protected boolean useResourceRoleMappings;
    protected boolean cors;
    protected int corsMaxAge = -1;
    protected String corsAllowedHeaders;
    protected String corsAllowedMethods;
    protected boolean exposeToken;
    protected boolean alwaysRefreshToken;
    protected boolean registerNodeAtStartup;
    protected int registerNodePeriod;
    protected volatile int notBefore;

    public boolean isConfigured() {
        return this.getRealm() != null && this.getRealmKey() != null && (this.isBearerOnly() || this.getAuthServerBaseUrl() != null);
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public PublicKey getRealmKey() {
        return this.realmKey;
    }

    public void setRealmKey(PublicKey realmKey) {
        this.realmKey = realmKey;
    }

    public String getAuthServerBaseUrl() {
        return this.authServerBaseUrl;
    }

    public void setAuthServerBaseUrl(AdapterConfig config) {
        this.authServerBaseUrl = config.getAuthServerUrl();
        String authServerURLForBackendReqs = config.getAuthServerUrlForBackendRequests();
        if (this.authServerBaseUrl == null && authServerURLForBackendReqs == null) {
            return;
        }
        URI authServerUri = null;
        if (this.authServerBaseUrl != null) {
            authServerUri = URI.create(this.authServerBaseUrl);
        }
        if (authServerUri == null || authServerUri.getHost() == null) {
            if (authServerURLForBackendReqs != null) {
                this.relativeUrls = RelativeUrlsUsed.BROWSER_ONLY;
                KeycloakUriBuilder serverBuilder = KeycloakUriBuilder.fromUri((String)authServerURLForBackendReqs);
                if (serverBuilder.getHost() == null || serverBuilder.getScheme() == null) {
                    throw new IllegalStateException("Relative URL not supported for auth-server-url-for-backend-requests option. URL used: " + authServerURLForBackendReqs + ", Client: " + config.getResource());
                }
                this.resolveNonBrowserUrls(serverBuilder);
            } else {
                this.relativeUrls = RelativeUrlsUsed.ALL_REQUESTS;
            }
        } else {
            this.relativeUrls = RelativeUrlsUsed.NEVER;
            KeycloakUriBuilder serverBuilder = KeycloakUriBuilder.fromUri((String)this.authServerBaseUrl);
            this.resolveBrowserUrls(serverBuilder);
            if (authServerURLForBackendReqs == null) {
                this.resolveNonBrowserUrls(serverBuilder);
            } else {
                serverBuilder = KeycloakUriBuilder.fromUri((String)authServerURLForBackendReqs);
                this.resolveNonBrowserUrls(serverBuilder);
            }
        }
    }

    protected void resolveBrowserUrls(KeycloakUriBuilder authUrlBuilder) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"resolveBrowserUrls");
        }
        String login = authUrlBuilder.clone().path("/realms/{realm-name}/protocol/openid-connect/auth").build(new Object[]{this.getRealm()}).toString();
        this.authUrl = KeycloakUriBuilder.fromUri((String)login);
        this.realmInfoUrl = authUrlBuilder.clone().path("/realms/{realm-name}").build(new Object[]{this.getRealm()}).toString();
    }

    protected void resolveNonBrowserUrls(KeycloakUriBuilder authUrlBuilder) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"resolveNonBrowserUrls");
        }
        this.tokenUrl = authUrlBuilder.clone().path("/realms/{realm-name}/protocol/openid-connect/token").build(new Object[]{this.getRealm()}).toString();
        this.logoutUrl = KeycloakUriBuilder.fromUri((String)authUrlBuilder.clone().path("/realms/{realm-name}/protocol/openid-connect/logout").build(new Object[]{this.getRealm()}).toString());
        this.accountUrl = authUrlBuilder.clone().path("/realms/{realm-name}/account").build(new Object[]{this.getRealm()}).toString();
        this.registerNodeUrl = authUrlBuilder.clone().path("/realms/{realm-name}/clients-managements/register-node").build(new Object[]{this.getRealm()}).toString();
        this.unregisterNodeUrl = authUrlBuilder.clone().path("/realms/{realm-name}/clients-managements/unregister-node").build(new Object[]{this.getRealm()}).toString();
    }

    public RelativeUrlsUsed getRelativeUrls() {
        return this.relativeUrls;
    }

    public String getRealmInfoUrl() {
        return this.realmInfoUrl;
    }

    public KeycloakUriBuilder getAuthUrl() {
        return this.authUrl;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public KeycloakUriBuilder getLogoutUrl() {
        return this.logoutUrl;
    }

    public String getAccountUrl() {
        return this.accountUrl;
    }

    public String getRegisterNodeUrl() {
        return this.registerNodeUrl;
    }

    public String getUnregisterNodeUrl() {
        return this.unregisterNodeUrl;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public boolean isBearerOnly() {
        return this.bearerOnly;
    }

    public void setBearerOnly(boolean bearerOnly) {
        this.bearerOnly = bearerOnly;
    }

    public boolean isEnableBasicAuth() {
        return this.enableBasicAuth;
    }

    public void setEnableBasicAuth(boolean enableBasicAuth) {
        this.enableBasicAuth = enableBasicAuth;
    }

    public boolean isPublicClient() {
        return this.publicClient;
    }

    public void setPublicClient(boolean publicClient) {
        this.publicClient = publicClient;
    }

    public Map<String, Object> getResourceCredentials() {
        return this.resourceCredentials;
    }

    public void setResourceCredentials(Map<String, Object> resourceCredentials) {
        this.resourceCredentials = resourceCredentials;
    }

    public ClientCredentialsProvider getClientAuthenticator() {
        return this.clientAuthenticator;
    }

    public void setClientAuthenticator(ClientCredentialsProvider clientAuthenticator) {
        this.clientAuthenticator = clientAuthenticator;
    }

    public HttpClient getClient() {
        return this.client;
    }

    public void setClient(HttpClient client) {
        this.client = client;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public SslRequired getSslRequired() {
        return this.sslRequired;
    }

    public void setSslRequired(SslRequired sslRequired) {
        this.sslRequired = sslRequired;
    }

    public TokenStore getTokenStore() {
        return this.tokenStore;
    }

    public void setTokenStore(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
    }

    public String getStateCookieName() {
        return this.stateCookieName;
    }

    public void setStateCookieName(String stateCookieName) {
        this.stateCookieName = stateCookieName;
    }

    public boolean isUseResourceRoleMappings() {
        return this.useResourceRoleMappings;
    }

    public void setUseResourceRoleMappings(boolean useResourceRoleMappings) {
        this.useResourceRoleMappings = useResourceRoleMappings;
    }

    public boolean isCors() {
        return this.cors;
    }

    public void setCors(boolean cors) {
        this.cors = cors;
    }

    public int getCorsMaxAge() {
        return this.corsMaxAge;
    }

    public void setCorsMaxAge(int corsMaxAge) {
        this.corsMaxAge = corsMaxAge;
    }

    public String getCorsAllowedHeaders() {
        return this.corsAllowedHeaders;
    }

    public void setCorsAllowedHeaders(String corsAllowedHeaders) {
        this.corsAllowedHeaders = corsAllowedHeaders;
    }

    public String getCorsAllowedMethods() {
        return this.corsAllowedMethods;
    }

    public void setCorsAllowedMethods(String corsAllowedMethods) {
        this.corsAllowedMethods = corsAllowedMethods;
    }

    public boolean isExposeToken() {
        return this.exposeToken;
    }

    public void setExposeToken(boolean exposeToken) {
        this.exposeToken = exposeToken;
    }

    public int getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(int notBefore) {
        this.notBefore = notBefore;
    }

    public boolean isAlwaysRefreshToken() {
        return this.alwaysRefreshToken;
    }

    public void setAlwaysRefreshToken(boolean alwaysRefreshToken) {
        this.alwaysRefreshToken = alwaysRefreshToken;
    }

    public boolean isRegisterNodeAtStartup() {
        return this.registerNodeAtStartup;
    }

    public void setRegisterNodeAtStartup(boolean registerNodeAtStartup) {
        this.registerNodeAtStartup = registerNodeAtStartup;
    }

    public int getRegisterNodePeriod() {
        return this.registerNodePeriod;
    }

    public void setRegisterNodePeriod(int registerNodePeriod) {
        this.registerNodePeriod = registerNodePeriod;
    }

    public String getPrincipalAttribute() {
        return this.principalAttribute;
    }

    public void setPrincipalAttribute(String principalAttribute) {
        this.principalAttribute = principalAttribute;
    }
}

