/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters;

import org.jboss.logging.Logger;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.AdapterUtils;
import org.keycloak.adapters.AuthChallenge;
import org.keycloak.adapters.AuthOutcome;
import org.keycloak.adapters.BasicAuthRequestAuthenticator;
import org.keycloak.adapters.BearerTokenRequestAuthenticator;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OAuthRequestAuthenticator;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;

public abstract class RequestAuthenticator {
    protected static Logger log = Logger.getLogger(RequestAuthenticator.class);
    protected HttpFacade facade;
    protected KeycloakDeployment deployment;
    protected AdapterTokenStore tokenStore;
    protected AuthChallenge challenge;
    protected int sslRedirectPort;

    public RequestAuthenticator(HttpFacade facade, KeycloakDeployment deployment, AdapterTokenStore tokenStore, int sslRedirectPort) {
        this.facade = facade;
        this.deployment = deployment;
        this.tokenStore = tokenStore;
        this.sslRedirectPort = sslRedirectPort;
    }

    public RequestAuthenticator(HttpFacade facade, KeycloakDeployment deployment) {
        this.facade = facade;
        this.deployment = deployment;
    }

    public AuthChallenge getChallenge() {
        return this.challenge;
    }

    public AuthOutcome authenticate() {
        AuthOutcome outcome;
        if (log.isTraceEnabled()) {
            log.trace((Object)"--> authenticate()");
        }
        BearerTokenRequestAuthenticator bearer = this.createBearerTokenAuthenticator();
        if (log.isTraceEnabled()) {
            log.trace((Object)"try bearer");
        }
        if ((outcome = bearer.authenticate(this.facade)) == AuthOutcome.FAILED) {
            this.challenge = bearer.getChallenge();
            log.debug((Object)"Bearer FAILED");
            return AuthOutcome.FAILED;
        }
        if (outcome == AuthOutcome.AUTHENTICATED) {
            if (this.verifySSL()) {
                return AuthOutcome.FAILED;
            }
            this.completeAuthentication(bearer, "KEYCLOAK");
            log.debug((Object)"Bearer AUTHENTICATED");
            return AuthOutcome.AUTHENTICATED;
        }
        if (this.deployment.isBearerOnly()) {
            this.challenge = bearer.getChallenge();
            log.debug((Object)"NOT_ATTEMPTED: bearer only");
            return AuthOutcome.NOT_ATTEMPTED;
        }
        if (this.deployment.isEnableBasicAuth()) {
            BasicAuthRequestAuthenticator basicAuth = this.createBasicAuthAuthenticator();
            if (log.isTraceEnabled()) {
                log.trace((Object)"try basic auth");
            }
            if ((outcome = basicAuth.authenticate(this.facade)) == AuthOutcome.FAILED) {
                this.challenge = basicAuth.getChallenge();
                log.debug((Object)"BasicAuth FAILED");
                return AuthOutcome.FAILED;
            }
            if (outcome == AuthOutcome.AUTHENTICATED) {
                log.debug((Object)"BasicAuth AUTHENTICATED");
                this.completeAuthentication(basicAuth, "BASIC");
                return AuthOutcome.AUTHENTICATED;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"try oauth");
        }
        if (this.tokenStore.isCached(this)) {
            if (this.verifySSL()) {
                return AuthOutcome.FAILED;
            }
            log.debug((Object)"AUTHENTICATED: was cached");
            return AuthOutcome.AUTHENTICATED;
        }
        OAuthRequestAuthenticator oauth = this.createOAuthAuthenticator();
        outcome = oauth.authenticate();
        if (outcome == AuthOutcome.FAILED) {
            this.challenge = oauth.getChallenge();
            return AuthOutcome.FAILED;
        }
        if (outcome == AuthOutcome.NOT_ATTEMPTED) {
            this.challenge = oauth.getChallenge();
            return AuthOutcome.NOT_ATTEMPTED;
        }
        if (this.verifySSL()) {
            return AuthOutcome.FAILED;
        }
        this.completeAuthentication(oauth);
        this.facade.getResponse().setHeader("Location", oauth.getStrippedOauthParametersRequestUri());
        this.facade.getResponse().setStatus(302);
        this.facade.getResponse().end();
        log.debug((Object)"AUTHENTICATED");
        return AuthOutcome.AUTHENTICATED;
    }

    protected boolean verifySSL() {
        if (!this.facade.getRequest().isSecure() && this.deployment.getSslRequired().isRequired(this.facade.getRequest().getRemoteAddr())) {
            log.warn((Object)"SSL is required to authenticate");
            return true;
        }
        return false;
    }

    protected abstract OAuthRequestAuthenticator createOAuthAuthenticator();

    protected BearerTokenRequestAuthenticator createBearerTokenAuthenticator() {
        return new BearerTokenRequestAuthenticator(this.deployment);
    }

    protected BasicAuthRequestAuthenticator createBasicAuthAuthenticator() {
        return new BasicAuthRequestAuthenticator(this.deployment);
    }

    protected void completeAuthentication(OAuthRequestAuthenticator oauth) {
        RefreshableKeycloakSecurityContext session = new RefreshableKeycloakSecurityContext(this.deployment, this.tokenStore, oauth.getTokenString(), oauth.getToken(), oauth.getIdTokenString(), oauth.getIdToken(), oauth.getRefreshToken());
        KeycloakPrincipal principal = new KeycloakPrincipal(AdapterUtils.getPrincipalName(this.deployment, oauth.getToken()), (KeycloakSecurityContext)session);
        this.completeOAuthAuthentication((KeycloakPrincipal<RefreshableKeycloakSecurityContext>)principal);
    }

    protected abstract void completeOAuthAuthentication(KeycloakPrincipal<RefreshableKeycloakSecurityContext> var1);

    protected abstract void completeBearerAuthentication(KeycloakPrincipal<RefreshableKeycloakSecurityContext> var1, String var2);

    protected abstract String getHttpSessionId(boolean var1);

    protected void completeAuthentication(BearerTokenRequestAuthenticator bearer, String method) {
        RefreshableKeycloakSecurityContext session = new RefreshableKeycloakSecurityContext(this.deployment, null, bearer.getTokenString(), bearer.getToken(), null, null, null);
        KeycloakPrincipal principal = new KeycloakPrincipal(AdapterUtils.getPrincipalName(this.deployment, bearer.getToken()), (KeycloakSecurityContext)session);
        this.completeBearerAuthentication((KeycloakPrincipal<RefreshableKeycloakSecurityContext>)principal, method);
    }
}

