/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters;

import java.io.IOException;
import java.security.PublicKey;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.logging.Logger;
import org.keycloak.RSATokenVerifier;
import org.keycloak.VerificationException;
import org.keycloak.adapters.AuthChallenge;
import org.keycloak.adapters.AuthOutcome;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.ServerRequest;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.IDToken;
import org.keycloak.util.KeycloakUriBuilder;

public abstract class OAuthRequestAuthenticator {
    private static final Logger log = Logger.getLogger(OAuthRequestAuthenticator.class);
    protected KeycloakDeployment deployment;
    protected int sslRedirectPort;
    protected String tokenString;
    protected String idTokenString;
    protected IDToken idToken;
    protected AccessToken token;
    protected HttpFacade facade;
    protected AuthChallenge challenge;
    protected String refreshToken;
    protected String strippedOauthParametersRequestUri;
    protected static final AtomicLong counter = new AtomicLong();

    public OAuthRequestAuthenticator(HttpFacade facade, KeycloakDeployment deployment, int sslRedirectPort) {
        this.facade = facade;
        this.deployment = deployment;
        this.sslRedirectPort = sslRedirectPort;
    }

    public AuthChallenge getChallenge() {
        return this.challenge;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public AccessToken getToken() {
        return this.token;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getIdTokenString() {
        return this.idTokenString;
    }

    public void setIdTokenString(String idTokenString) {
        this.idTokenString = idTokenString;
    }

    public IDToken getIdToken() {
        return this.idToken;
    }

    public void setIdToken(IDToken idToken) {
        this.idToken = idToken;
    }

    public String getStrippedOauthParametersRequestUri() {
        return this.strippedOauthParametersRequestUri;
    }

    public void setStrippedOauthParametersRequestUri(String strippedOauthParametersRequestUri) {
        this.strippedOauthParametersRequestUri = strippedOauthParametersRequestUri;
    }

    protected String getRequestUrl() {
        return this.facade.getRequest().getURI();
    }

    protected boolean isRequestSecure() {
        return this.facade.getRequest().isSecure();
    }

    protected HttpFacade.Cookie getCookie(String cookieName) {
        return this.facade.getRequest().getCookie(cookieName);
    }

    protected String getCookieValue(String cookieName) {
        HttpFacade.Cookie cookie = this.getCookie(cookieName);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    protected String getQueryParamValue(String paramName) {
        return this.facade.getRequest().getQueryParamValue(paramName);
    }

    protected String getError() {
        return this.getQueryParamValue("error");
    }

    protected String getCode() {
        return this.getQueryParamValue("code");
    }

    protected String getRedirectUri(String state) {
        String url = this.getRequestUrl();
        log.debugf("callback uri: %s", (Object)url);
        if (!this.facade.getRequest().isSecure() && this.deployment.getSslRequired().isRequired(this.facade.getRequest().getRemoteAddr())) {
            int port = this.sslRedirectPort();
            if (port < 0) {
                return null;
            }
            KeycloakUriBuilder secureUrl = KeycloakUriBuilder.fromUri((String)url).scheme("https").port(-1);
            if (port != 443) {
                secureUrl.port(port);
            }
            url = secureUrl.build(new Object[0]).toString();
        }
        return this.deployment.getAuthUrl().clone().queryParam("client_id", new Object[]{this.deployment.getResourceName()}).queryParam("redirect_uri", new Object[]{url}).queryParam("state", new Object[]{state}).queryParam("login", new Object[]{"true"}).build(new Object[0]).toString();
    }

    protected int sslRedirectPort() {
        return this.sslRedirectPort;
    }

    protected String getStateCode() {
        return counter.getAndIncrement() + "/" + UUID.randomUUID().toString();
    }

    protected AuthChallenge loginRedirect() {
        final String state = this.getStateCode();
        final String redirect = this.getRedirectUri(state);
        return new AuthChallenge(){

            @Override
            public boolean challenge(HttpFacade exchange) {
                if (redirect == null) {
                    exchange.getResponse().setStatus(403);
                    return true;
                }
                log.debug((Object)("Sending redirect to login page: " + redirect));
                exchange.getResponse().setStatus(302);
                exchange.getResponse().setCookie(OAuthRequestAuthenticator.this.deployment.getStateCookieName(), state, null, null, -1, OAuthRequestAuthenticator.this.deployment.getSslRequired().isRequired(OAuthRequestAuthenticator.this.facade.getRequest().getRemoteAddr()), false);
                exchange.getResponse().setHeader("Location", redirect);
                return true;
            }
        };
    }

    protected AuthChallenge checkStateCookie() {
        HttpFacade.Cookie stateCookie = this.getCookie(this.deployment.getStateCookieName());
        if (stateCookie == null) {
            log.warn((Object)"No state cookie");
            return this.challenge(400);
        }
        log.debug((Object)"** reseting application state cookie");
        this.facade.getResponse().resetCookie(this.deployment.getStateCookieName(), stateCookie.getPath());
        String stateCookieValue = this.getCookieValue(this.deployment.getStateCookieName());
        String state = this.getQueryParamValue("state");
        if (state == null) {
            log.warn((Object)"state parameter was null");
            return this.challenge(400);
        }
        if (!state.equals(stateCookieValue)) {
            log.warn((Object)"state parameter invalid");
            log.warn((Object)("cookie: " + stateCookieValue));
            log.warn((Object)("queryParam: " + state));
            return this.challenge(400);
        }
        return null;
    }

    public AuthOutcome authenticate() {
        String code = this.getCode();
        if (code == null) {
            log.debug((Object)"there was no code");
            String error = this.getError();
            if (error != null) {
                log.warn((Object)("There was an error: " + error));
                this.challenge = this.challenge(400);
                return AuthOutcome.FAILED;
            }
            log.debug((Object)"redirecting to auth server");
            this.challenge = this.loginRedirect();
            this.saveRequest();
            return AuthOutcome.NOT_ATTEMPTED;
        }
        log.debug((Object)"there was a code, resolving");
        this.challenge = this.resolveCode(code);
        if (this.challenge != null) {
            return AuthOutcome.FAILED;
        }
        return AuthOutcome.AUTHENTICATED;
    }

    protected abstract void saveRequest();

    protected AuthChallenge challenge(final int code) {
        return new AuthChallenge(){

            @Override
            public boolean challenge(HttpFacade exchange) {
                exchange.getResponse().setStatus(code);
                return true;
            }
        };
    }

    protected AuthChallenge resolveCode(String code) {
        if (!this.isRequestSecure() && this.deployment.getSslRequired().isRequired(this.facade.getRequest().getRemoteAddr())) {
            log.error((Object)("Adapter requires SSL. Request: " + this.facade.getRequest().getURI()));
            return this.challenge(403);
        }
        log.debug((Object)"checking state cookie for after code");
        AuthChallenge challenge = this.checkStateCookie();
        if (challenge != null) {
            return challenge;
        }
        AccessTokenResponse tokenResponse = null;
        this.strippedOauthParametersRequestUri = this.stripOauthParametersFromRedirect();
        try {
            tokenResponse = ServerRequest.invokeAccessCodeToToken(this.deployment, code, this.strippedOauthParametersRequestUri);
        }
        catch (ServerRequest.HttpFailure failure) {
            log.error((Object)"failed to turn code into token");
            log.error((Object)("status from server: " + failure.getStatus()));
            if (failure.getStatus() == 400 && failure.getError() != null) {
                log.error((Object)("   " + failure.getError()));
            }
            return this.challenge(403);
        }
        catch (IOException e) {
            log.error((Object)"failed to turn code into token", (Throwable)e);
            return this.challenge(403);
        }
        this.tokenString = tokenResponse.getToken();
        this.refreshToken = tokenResponse.getRefreshToken();
        this.idTokenString = tokenResponse.getIdToken();
        try {
            this.token = RSATokenVerifier.verifyToken((String)this.tokenString, (PublicKey)this.deployment.getRealmKey(), (String)this.deployment.getRealm());
            if (this.idTokenString != null) {
                JWSInput input = new JWSInput(this.idTokenString);
                try {
                    this.idToken = (IDToken)input.readJsonContent(IDToken.class);
                }
                catch (IOException e) {
                    throw new VerificationException();
                }
            }
            log.debug((Object)"Token Verification succeeded!");
        }
        catch (VerificationException e) {
            log.error((Object)"failed verification of token");
            return this.challenge(403);
        }
        if (tokenResponse.getNotBeforePolicy() > this.deployment.getNotBefore()) {
            this.deployment.setNotBefore(tokenResponse.getNotBeforePolicy());
        }
        if (this.token.getIssuedAt() < this.deployment.getNotBefore()) {
            log.error((Object)"Stale token");
            return this.challenge(403);
        }
        log.debug((Object)"successful authenticated");
        return null;
    }

    protected String stripOauthParametersFromRedirect() {
        KeycloakUriBuilder builder = KeycloakUriBuilder.fromUri((String)this.facade.getRequest().getURI()).replaceQueryParam("code", null).replaceQueryParam("state", null);
        return builder.build(new Object[0]).toString();
    }
}

