/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.engines;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.jboss.resteasy.util.CaseInsensitiveMap;

public class URLConnectionEngine
implements ClientHttpEngine {
    protected SSLContext sslContext;
    protected HostnameVerifier hostnameVerifier;

    @Override
    public ClientResponse invoke(ClientInvocation request) {
        int status;
        HttpURLConnection connection;
        try {
            connection = this.createConnection(request);
            this.executeRequest(request, connection);
            status = connection.getResponseCode();
        }
        catch (IOException e) {
            throw new ProcessingException(Messages.MESSAGES.unableToInvokeRequest(), e);
        }
        ClientResponse response = new ClientResponse(request.getClientConfiguration()){
            private InputStream stream;

            @Override
            protected InputStream getInputStream() {
                if (this.stream == null) {
                    try {
                        this.stream = this.status < 300 ? connection.getInputStream() : connection.getErrorStream();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return this.stream;
            }

            @Override
            protected void setInputStream(InputStream is) {
                this.stream = is;
                this.resetEntity();
            }

            @Override
            public void releaseConnection() throws IOException {
                this.releaseConnection(false);
            }

            @Override
            public void releaseConnection(boolean consumeInputStream) throws IOException {
                InputStream is = this.getInputStream();
                if (is != null) {
                    if (consumeInputStream) {
                        while (is.read() > 0) {
                        }
                    }
                    is.close();
                }
                connection.disconnect();
            }
        };
        response.setStatus(status);
        response.setHeaders(this.getHeaders(connection));
        return response;
    }

    protected MultivaluedMap<String, String> getHeaders(HttpURLConnection connection) {
        CaseInsensitiveMap<String> headers = new CaseInsensitiveMap<String>();
        for (Map.Entry<String, List<String>> header : connection.getHeaderFields().entrySet()) {
            if (header.getKey() == null) continue;
            for (String value : header.getValue()) {
                headers.add(header.getKey(), value);
            }
        }
        return headers;
    }

    @Override
    public void close() {
    }

    protected HttpURLConnection createConnection(ClientInvocation request) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)request.getUri().toURL().openConnection();
        connection.setRequestMethod(request.getMethod());
        return connection;
    }

    protected void executeRequest(ClientInvocation request, HttpURLConnection connection) {
        connection.setInstanceFollowRedirects(request.getMethod().equals("GET"));
        if (request.getEntity() != null) {
            if (request.getMethod().equals("GET")) {
                throw new ProcessingException(Messages.MESSAGES.getRequestCannotHaveBody());
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            request.getDelegatingOutputStream().setDelegate(baos);
            try {
                request.writeRequestBody(request.getEntityStream());
                baos.close();
                this.commitHeaders(request, connection);
                connection.setDoOutput(true);
                OutputStream os = connection.getOutputStream();
                os.write(baos.toByteArray());
                os.flush();
                os.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.commitHeaders(request, connection);
        }
    }

    protected void commitHeaders(ClientInvocation request, HttpURLConnection connection) {
        MultivaluedMap<String, String> headers = request.getHeaders().asMap();
        for (Map.Entry header : headers.entrySet()) {
            List values = (List)header.getValue();
            for (String value : values) {
                connection.addRequestProperty((String)header.getKey(), value);
            }
        }
    }

    @Override
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }
}

