/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jwe;

import java.util.HashMap;
import java.util.Map;
import org.keycloak.jose.jwe.alg.AesKeyWrapAlgorithmProvider;
import org.keycloak.jose.jwe.alg.DirectAlgorithmProvider;
import org.keycloak.jose.jwe.alg.JWEAlgorithmProvider;
import org.keycloak.jose.jwe.enc.AesCbcHmacShaEncryptionProvider;
import org.keycloak.jose.jwe.enc.JWEEncryptionProvider;

class JWERegistry {
    private static final Map<String, JWEEncryptionProvider> ENC_PROVIDERS = new HashMap<String, JWEEncryptionProvider>();
    private static final Map<String, JWEAlgorithmProvider> ALG_PROVIDERS = new HashMap<String, JWEAlgorithmProvider>();

    JWERegistry() {
    }

    static JWEAlgorithmProvider getAlgProvider(String alg) {
        return ALG_PROVIDERS.get(alg);
    }

    static JWEEncryptionProvider getEncProvider(String enc) {
        return ENC_PROVIDERS.get(enc);
    }

    static {
        ALG_PROVIDERS.put("dir", new DirectAlgorithmProvider());
        ALG_PROVIDERS.put("A128KW", new AesKeyWrapAlgorithmProvider());
        ENC_PROVIDERS.put("A128CBC-HS256", new AesCbcHmacShaEncryptionProvider.Aes128CbcHmacSha256Provider());
        ENC_PROVIDERS.put("A192CBC-HS384", new AesCbcHmacShaEncryptionProvider.Aes192CbcHmacSha384Provider());
        ENC_PROVIDERS.put("A256CBC-HS512", new AesCbcHmacShaEncryptionProvider.Aes256CbcHmacSha512Provider());
    }
}

