/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import org.jboss.resteasy.plugins.server.servlet.HttpServletResponseHeaders;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class HttpServletResponseWrapper
implements HttpResponse {
    protected HttpServletResponse response;
    protected int status = 200;
    protected MultivaluedMap<String, Object> outputHeaders;
    protected ResteasyProviderFactory factory;
    protected OutputStream outputStream = new DeferredOutputStream();

    public HttpServletResponseWrapper(HttpServletResponse response, ResteasyProviderFactory factory) {
        this.response = response;
        this.outputHeaders = new HttpServletResponseHeaders(response, factory);
        this.factory = factory;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
        this.response.setStatus(status);
    }

    @Override
    public MultivaluedMap<String, Object> getOutputHeaders() {
        return this.outputHeaders;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    @Override
    public void setOutputStream(OutputStream os) {
        this.outputStream = os;
    }

    @Override
    public void addNewCookie(NewCookie cookie) {
        this.outputHeaders.add("Set-Cookie", cookie);
    }

    @Override
    public void sendError(int status) throws IOException {
        this.response.sendError(status);
    }

    @Override
    public void sendError(int status, String message) throws IOException {
        this.response.sendError(status, message);
    }

    @Override
    public boolean isCommitted() {
        return this.response.isCommitted();
    }

    @Override
    public void reset() {
        this.response.reset();
        this.outputHeaders = new HttpServletResponseHeaders(this.response, this.factory);
    }

    @Override
    public void flushBuffer() throws IOException {
        this.response.flushBuffer();
    }

    protected class DeferredOutputStream
    extends OutputStream {
        protected DeferredOutputStream() {
        }

        @Override
        public void write(int i) throws IOException {
            HttpServletResponseWrapper.this.response.getOutputStream().write(i);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            HttpServletResponseWrapper.this.response.getOutputStream().write(bytes);
        }

        @Override
        public void write(byte[] bytes, int i, int i1) throws IOException {
            HttpServletResponseWrapper.this.response.getOutputStream().write(bytes, i, i1);
        }

        @Override
        public void flush() throws IOException {
            HttpServletResponseWrapper.this.response.getOutputStream().flush();
        }

        @Override
        public void close() throws IOException {
            HttpServletResponseWrapper.this.response.getOutputStream().close();
        }
    }
}

