/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.sse;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.SseEventSink;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.SseElementType;
import org.jboss.resteasy.annotations.Stream;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ServerResponseWriter;
import org.jboss.resteasy.plugins.providers.sse.OutboundSseEventImpl;
import org.jboss.resteasy.plugins.providers.sse.SseConstants;
import org.jboss.resteasy.plugins.server.servlet.Cleanable;
import org.jboss.resteasy.plugins.server.servlet.Cleanables;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyAsynchronousContext;
import org.jboss.resteasy.spi.ResteasyAsynchronousResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.FindAnnotation;

public class SseEventOutputImpl
extends GenericType<OutboundSseEvent>
implements SseEventSink {
    private static final Logger LOG = Logger.getLogger(SseEventOutputImpl.class);
    private final MessageBodyWriter<OutboundSseEvent> writer;
    private final ResteasyAsynchronousContext asyncContext;
    private final HttpResponse response;
    private final HttpRequest request;
    private volatile boolean closed;
    private final Map<Class<?>, Object> contextDataMap;
    private volatile boolean responseFlushed = false;
    private final Object lock = new Object();

    public SseEventOutputImpl(MessageBodyWriter<OutboundSseEvent> writer) {
        this.writer = writer;
        this.contextDataMap = ResteasyProviderFactory.getContextDataMap();
        this.request = ResteasyProviderFactory.getContextData(HttpRequest.class);
        this.asyncContext = this.request.getAsyncContext();
        if (!this.asyncContext.isSuspended()) {
            try {
                this.asyncContext.suspend();
            }
            catch (IllegalStateException ex) {
                LogMessages.LOGGER.failedToSetRequestAsync();
            }
        }
        this.response = ResteasyProviderFactory.getContextData(HttpResponse.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            block8: {
                ResteasyAsynchronousResponse asyncResponse;
                this.closed = true;
                if (this.asyncContext.isSuspended() && (asyncResponse = this.asyncContext.getAsyncResponse()) != null) {
                    try {
                        asyncResponse.complete();
                    }
                    catch (RuntimeException x) {
                        Throwable cause = x;
                        while (cause.getCause() != null) {
                            cause = cause.getCause();
                        }
                        if (cause instanceof IOException) break block8;
                        LOG.debug(cause.getMessage());
                        return;
                    }
                }
            }
            this.clearContextData();
        }
    }

    public void clearContextData() {
        Cleanables cleanables;
        Map<Class<?>, Object> map = ResteasyProviderFactory.getContextDataMap(false);
        Cleanables cleanables2 = cleanables = map != null ? (Cleanables)map.get(Cleanables.class) : null;
        if (cleanables != null) {
            Iterator<Cleanable> it = cleanables.getCleanables().iterator();
            while (it.hasNext()) {
                try {
                    it.next().clean();
                }
                catch (Exception exception) {}
            }
            ResteasyProviderFactory.clearContextData();
        }
    }

    protected void flushResponseToClient() {
        try {
            this.internalFlushResponseToClient(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalFlushResponseToClient(boolean throwIOException) throws IOException {
        if (this.responseFlushed) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.responseFlushed) {
                BuiltResponse jaxrsResponse = null;
                if (this.closed) {
                    jaxrsResponse = (BuiltResponse)Response.noContent().build();
                } else {
                    ResourceMethodInvoker method = (ResourceMethodInvoker)this.request.getAttribute(ResourceMethodInvoker.class.getName());
                    MediaType[] mediaTypes = method.getProduces();
                    if (mediaTypes != null && Arrays.asList(mediaTypes).contains(MediaType.SERVER_SENT_EVENTS_TYPE)) {
                        SseElementType sseElementType = FindAnnotation.findAnnotation(method.getMethodAnnotations(), SseElementType.class);
                        if (sseElementType != null) {
                            HashMap<String, String> parameterMap = new HashMap<String, String>();
                            parameterMap.put("element-type", sseElementType.value());
                            MediaType mediaType = new MediaType(MediaType.SERVER_SENT_EVENTS_TYPE.getType(), MediaType.SERVER_SENT_EVENTS_TYPE.getSubtype(), parameterMap);
                            jaxrsResponse = (BuiltResponse)Response.ok().type(mediaType).build();
                        } else {
                            jaxrsResponse = (BuiltResponse)Response.ok().type("text/event-stream").build();
                        }
                    } else {
                        Stream stream = FindAnnotation.findAnnotation(method.getMethodAnnotations(), Stream.class);
                        if (stream != null) {
                            jaxrsResponse = (BuiltResponse)Response.ok("").build();
                            MediaType elementType = ServerResponseWriter.getResponseMediaType(jaxrsResponse, this.request, this.response, ResteasyProviderFactory.getInstance(), method);
                            HashMap<String, String> parameterMap = new HashMap<String, String>();
                            parameterMap.put("element-type", elementType.toString());
                            String[] streamType = this.getStreamType(method);
                            MediaType mediaType = new MediaType(streamType[0], streamType[1], parameterMap);
                            jaxrsResponse = (BuiltResponse)Response.ok().type(mediaType).build();
                        } else {
                            throw new RuntimeException(Messages.MESSAGES.expectedStreamOrSseMediaType());
                        }
                    }
                }
                try {
                    ServerResponseWriter.writeNomapResponse(jaxrsResponse, this.request, this.response, ResteasyProviderFactory.getInstance(), t -> {}, true);
                    this.response.getOutputStream().write(SseConstants.EOL);
                    this.response.getOutputStream().write(SseConstants.EOL);
                    this.response.flushBuffer();
                    this.responseFlushed = true;
                }
                catch (IOException e) {
                    this.close();
                    if (throwIOException) {
                        throw e;
                    }
                    throw new ProcessingException(Messages.MESSAGES.failedToCreateSseEventOutput(), e);
                }
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> send(OutboundSseEvent event) {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException(Messages.MESSAGES.sseEventSinkIsClosed());
            }
            try {
                this.internalFlushResponseToClient(true);
                this.writeEvent(event);
            }
            catch (Exception ex) {
                CompletableFuture completableFuture = new CompletableFuture();
                completableFuture.completeExceptionally(ex);
                return completableFuture;
            }
            return CompletableFuture.completedFuture(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeEvent(OutboundSseEvent event) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try (ResteasyProviderFactory.CloseableContext c = ResteasyProviderFactory.addCloseableContextDataLevel(this.contextDataMap);){
                if (event != null) {
                    Object o;
                    boolean mediaTypeSet;
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    MediaType mediaType = event.getMediaType();
                    boolean bl = mediaTypeSet = event instanceof OutboundSseEventImpl ? ((OutboundSseEventImpl)event).isMediaTypeSet() : true;
                    if (!(mediaType != null && mediaTypeSet || (o = this.response.getOutputHeaders().getFirst("Content-Type")) == null)) {
                        if (o instanceof MediaType) {
                            MediaType mt = (MediaType)o;
                            String s = mt.getParameters().get("element-type");
                            if (s != null) {
                                mediaType = MediaType.valueOf(s);
                            }
                        } else if (o instanceof String) {
                            MediaType mt = MediaType.valueOf((String)o);
                            String s = mt.getParameters().get("element-type");
                            if (s != null) {
                                mediaType = MediaType.valueOf(s);
                            }
                        } else {
                            throw new RuntimeException(Messages.MESSAGES.expectedStringOrMediaType(o));
                        }
                    }
                    if (mediaType == null) {
                        mediaType = MediaType.TEXT_PLAIN_TYPE;
                    }
                    if (event instanceof OutboundSseEventImpl) {
                        ((OutboundSseEventImpl)event).setMediaType(mediaType);
                    }
                    this.writer.writeTo(event, event.getClass(), null, new Annotation[0], mediaType, null, bout);
                    this.response.getOutputStream().write(bout.toByteArray());
                    this.response.flushBuffer();
                }
            }
            catch (IOException e) {
                this.close();
                LogMessages.LOGGER.failedToWriteSseEvent(event.toString(), e);
                throw e;
            }
            catch (Exception e) {
                LogMessages.LOGGER.failedToWriteSseEvent(event.toString(), e);
                throw new ProcessingException(e);
            }
        }
    }

    private String[] getStreamType(ResourceMethodInvoker method) {
        Stream.MODE mode;
        Stream stream = FindAnnotation.findAnnotation(method.getMethodAnnotations(), Stream.class);
        Stream.MODE mODE = mode = stream != null ? stream.value() : null;
        if (mode == null) {
            return new String[]{"text", "event-stream"};
        }
        if (Stream.MODE.GENERAL.equals((Object)mode)) {
            return new String[]{"application", "x-stream-general"};
        }
        if (Stream.MODE.RAW.equals((Object)mode)) {
            return new String[]{"application", "x-stream-raw"};
        }
        throw new RuntimeException(Messages.MESSAGES.expectedStreamModeGeneralOrRaw(mode));
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return ((Object)this).hashCode();
    }
}

