/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.util.regex.Pattern;
import org.jboss.logging.Logger;

public class StackUtil {
    private static final Logger LOG = Logger.getLogger("org.keycloak.STACK_TRACE");
    private static final Pattern IGNORED = Pattern.compile("^sun\\.|java\\.lang\\.reflect\\.");
    private static final StringBuilder EMPTY = new StringBuilder(0);

    public static StringBuilder getShortStackTrace() {
        return StackUtil.getShortStackTrace("\n    ");
    }

    public static StringBuilder getShortStackTrace(String prefix) {
        if (!LOG.isTraceEnabled()) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        for (int endIndex = 2; endIndex < stackTrace.length; ++endIndex) {
            StackTraceElement st = stackTrace[endIndex];
            if (IGNORED.matcher(st.getClassName()).find()) continue;
            if (st.getClassName().startsWith("org.jboss.resteasy")) break;
            sb.append(prefix).append(st);
        }
        return sb;
    }
}

