/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb.proc;

import java.util.Collections;
import java.util.List;
import org.kefirsf.bb.proc.Check;
import org.kefirsf.bb.proc.Context;
import org.kefirsf.bb.proc.NestingException;
import org.kefirsf.bb.proc.PatternConstant;
import org.kefirsf.bb.proc.ProcEol;
import org.kefirsf.bb.proc.ProcPatternElement;
import org.kefirsf.bb.proc.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcPattern {
    private final Logger log = LoggerFactory.getLogger((String)"kefirbb.parse");
    private final List<? extends ProcPatternElement> elements;
    private final ProcPatternElement firstElement;
    private final int patternSize;

    public ProcPattern(List<? extends ProcPatternElement> elements) {
        this.elements = Collections.unmodifiableList(elements);
        this.patternSize = elements.size();
        if (this.elements.isEmpty()) {
            throw new IllegalArgumentException("Parameter \"elements\" can't be empty.");
        }
        this.firstElement = this.elements.get(0);
    }

    public boolean suspicious(Context context) {
        return this.firstElement.isNextIn(context);
    }

    public boolean parse(Context context) throws NestingException {
        int i;
        boolean flag = true;
        Source source = context.getSource();
        int offset = source.getOffset();
        if (this.log.isTraceEnabled()) {
            this.log.trace("[{}] Begin {}", (Object)offset, (Object)this);
        }
        for (i = 0; i < this.patternSize && flag; ++i) {
            ProcPatternElement current = this.elements.get(i);
            ProcPatternElement next = i < this.patternSize - 1 ? this.elements.get(i + 1) : context.getTerminator();
            flag = current.parse(context, next);
        }
        if (!flag) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("[{}] Rollback {} on {} element", new Object[]{source.getOffset(), this, i});
            }
            source.setOffset(offset);
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("[{}] Complete {}", (Object)source.getOffset(), (Object)this);
        }
        return flag;
    }

    public boolean startsWithConstant() {
        return this.firstElement instanceof PatternConstant || this.firstElement instanceof ProcEol;
    }

    public boolean hasCheck() {
        for (ProcPatternElement procPatternElement : this.elements) {
            if (!(procPatternElement instanceof Check)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("<pattern>");
        for (ProcPatternElement procPatternElement : this.elements) {
            b.append(procPatternElement);
        }
        b.append("</pattern>");
        return b.toString();
    }
}

