/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb.proc;

import java.text.MessageFormat;
import java.util.regex.Matcher;
import org.kefirsf.bb.proc.AbstractUrl;
import org.kefirsf.bb.proc.ProcPatternElement;
import org.kefirsf.bb.proc.Source;

public class ProcEmail
extends AbstractUrl {
    public ProcEmail(String name, boolean ghost) {
        super(name, ghost);
    }

    public int findIn(Source source) {
        Matcher matcher = REGEX_AUTHORITY.matcher(source.subToEnd());
        int offset = -1;
        while (matcher.find()) {
            int matcherPosition = source.getOffset() + matcher.start();
            if (this.parseLength(source, matcherPosition, null) <= 0) continue;
            offset = matcherPosition;
            break;
        }
        return offset;
    }

    int parseLength(Source source, int offset, ProcPatternElement terminator) {
        int length = 0;
        int authorityLength = this.parseAuthority(source, offset + length);
        if (authorityLength <= 0) {
            return -1;
        }
        int hostLength = this.parseHost(source, offset + (length += authorityLength), terminator);
        if (hostLength <= 0) {
            return -1;
        }
        length += hostLength;
        length += this.parseQuery(source, offset + length, terminator);
        return length;
    }

    public String toString() {
        return MessageFormat.format("<email name=\"{0}\" ghost=\"{1}\"/>", this.getName(), this.ghost);
    }
}

