/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb.proc;

import org.kefirsf.bb.proc.AbstractEol;
import org.kefirsf.bb.proc.Context;
import org.kefirsf.bb.proc.NestingException;
import org.kefirsf.bb.proc.ProcPatternElement;
import org.kefirsf.bb.proc.Source;

public class ProcBol
implements ProcPatternElement {
    public boolean parse(Context context, ProcPatternElement terminator) throws NestingException {
        return this.isNextIn(context);
    }

    public boolean isNextIn(Context context) {
        Source source = context.getSource();
        return source.hasNext() && this.onBol(source);
    }

    public int findIn(Source source) {
        if (source.hasNext()) {
            if (this.onBol(source)) {
                return source.getOffset();
            }
            int index = this.findLineBreak(source);
            if (index < 0) {
                return -1;
            }
            if ((index = this.skipLineBreak(source, index)) < source.length()) {
                return index;
            }
            return -1;
        }
        return -1;
    }

    private boolean onBol(Source source) {
        int offset = source.getOffset();
        if (offset == 0) {
            return true;
        }
        char c = source.charAt(offset);
        char p = source.charAt(offset - 1);
        return c != '\n' && c != '\r' && (p == '\n' || p == '\r');
    }

    private int findLineBreak(Source source) {
        int n = source.find(AbstractEol.AN, false);
        int r = source.find(AbstractEol.AR, false);
        int index = n >= 0 && r >= 0 ? Math.min(n, r) : (n >= 0 ? n : (r >= 0 ? r : -1));
        return index;
    }

    private int skipLineBreak(Source source, int offset) {
        char c;
        int index = offset;
        char p = source.charAt(index);
        if (++index < source.length() && ((c = source.charAt(index)) == '\n' || c == '\r') && c != p) {
            ++index;
        }
        return index;
    }

    public String toString() {
        return "<bol/>";
    }
}

