/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb.proc;

import java.util.HashMap;
import java.util.Map;
import org.kefirsf.bb.proc.NestingException;
import org.kefirsf.bb.proc.ProcPatternElement;
import org.kefirsf.bb.proc.ProcScope;
import org.kefirsf.bb.proc.Source;
import org.kefirsf.bb.util.IntSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context {
    private final Context parent;
    private Source source;
    private Appendable target = null;
    private ProcPatternElement terminator = null;
    private ProcScope scope;
    private final Map<String, CharSequence> attributes = new HashMap<String, CharSequence>();
    private final Map<ProcScope, IntSet> falseMemo;
    private IntSet scopeFalseMemo;
    private int nestingLimit;

    public Context() {
        this.parent = null;
        this.falseMemo = new HashMap<ProcScope, IntSet>();
    }

    public Context(Context parent) {
        this.parent = parent;
        this.source = parent.source;
        this.target = parent.target;
        this.falseMemo = parent.falseMemo;
        this.terminator = parent.terminator;
        this.nestingLimit = parent.nestingLimit - 1;
        this.setScope(parent.scope);
    }

    public void addBadTag(int offset) {
        this.scopeFalseMemo.add(offset);
    }

    public boolean checkBadTag(int offset) {
        return this.scopeFalseMemo.contains(offset);
    }

    public boolean hasNextAdjustedForTerminator() {
        return this.terminator == null || !this.terminator.isNextIn(this);
    }

    public void mergeWithParent() {
        this.parent.attributes.putAll(this.attributes);
    }

    public void setAttribute(String name, CharSequence value) {
        this.attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        Object value = this.getLocalAttribute(name);
        if (value == null && this.parent != null) {
            value = this.parent.getAttribute(name);
        }
        return value;
    }

    public Object getLocalAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setScope(ProcScope scope) {
        this.scope = scope;
        this.scopeFalseMemo = this.falseMemo.get(scope);
        if (this.scopeFalseMemo == null) {
            this.scopeFalseMemo = new IntSet();
            this.falseMemo.put(scope, this.scopeFalseMemo);
        }
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public Appendable getTarget() {
        return this.target;
    }

    public void setTarget(Appendable target) {
        this.target = target;
    }

    public ProcPatternElement getTerminator() {
        return this.terminator;
    }

    public void setTerminator(ProcPatternElement terminator) {
        this.terminator = terminator;
    }

    public ProcScope getScope() {
        return this.scope;
    }

    public void setNestingLimit(int nestingLimit) {
        this.nestingLimit = nestingLimit;
    }

    public void checkNesting() throws NestingException {
        if (this.nestingLimit < 0) {
            throw new NestingException();
        }
    }

    public Map<String, CharSequence> getAttributes() {
        return this.attributes;
    }
}

