/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb.proc;

import org.kefirsf.bb.proc.Context;
import org.kefirsf.bb.proc.NestingException;
import org.kefirsf.bb.proc.ProcPatternElement;
import org.kefirsf.bb.proc.Source;

public abstract class AbstractEol
implements ProcPatternElement {
    protected static final char[] AN = new char[]{'\n'};
    protected static final char[] AR = new char[]{'\r'};
    protected final boolean ghost;

    public AbstractEol(boolean ghost) {
        this.ghost = ghost;
    }

    public boolean parse(Context context, ProcPatternElement terminator) throws NestingException {
        Source source = context.getSource();
        int len = this.match(source);
        if (len >= 0) {
            if (!this.ghost) {
                source.incOffset(len);
            }
            return true;
        }
        return false;
    }

    private int match(Source source) {
        return this.match(source, source.getOffset());
    }

    public boolean isNextIn(Context context) {
        return this.match(context.getSource()) >= 0;
    }

    public int findIn(Source source) {
        int r;
        int n;
        int index = source.getOffset() - 1;
        do {
            n = source.findFrom(++index, AN, false);
            r = source.findFrom(index, AR, false);
        } while (this.match(source, index = n >= 0 && r >= 0 ? Math.min(n, r) : (n >= 0 ? n : (r >= 0 ? r : source.length()))) < 0);
        return index;
    }

    protected abstract int match(Source var1, int var2);

    protected int calcLength(Source source, int index) {
        if (index >= source.length()) {
            return 0;
        }
        char c = source.charAt(index);
        if (c == '\n' || c == '\r') {
            if (index + 1 < source.length()) {
                char nc = source.charAt(index + 1);
                if (c == '\n' && nc == '\r' || c == '\r' && nc == '\n') {
                    return 2;
                }
            }
            return 1;
        }
        return -1;
    }
}

