/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb;

import java.util.ArrayList;
import java.util.List;
import org.kefirsf.bb.TextProcessorFactoryException;
import org.kefirsf.bb.conf.Constant;
import org.kefirsf.bb.conf.If;
import org.kefirsf.bb.conf.NamedValue;
import org.kefirsf.bb.conf.TemplateElement;
import org.kefirsf.bb.proc.IfExpression;
import org.kefirsf.bb.proc.ProcNamedValue;
import org.kefirsf.bb.proc.ProcTemplateElement;
import org.kefirsf.bb.proc.TemplateConstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TemplateElementFactory {
    List<ProcTemplateElement> createTemplateList(List<? extends TemplateElement> templateElements) {
        ArrayList<ProcTemplateElement> elements = new ArrayList<ProcTemplateElement>();
        for (TemplateElement templateElement : templateElements) {
            elements.add(this.create(templateElement));
        }
        return elements;
    }

    private ProcTemplateElement create(TemplateElement element) {
        if (element instanceof Constant) {
            return new TemplateConstant(((Constant)element).getValue());
        }
        if (element instanceof NamedValue) {
            NamedValue el = (NamedValue)element;
            return new ProcNamedValue(el.getName(), el.getFunction());
        }
        if (element instanceof If) {
            return this.createIf((If)element);
        }
        throw new TextProcessorFactoryException("Unknown template element " + element.getClass().getName() + ".");
    }

    private ProcTemplateElement createIf(If element) {
        return new IfExpression(element.getName(), this.createTemplateList(element.getElements()));
    }
}

