/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.kefirsf.bb.PatternElementFactory;
import org.kefirsf.bb.TemplateElementFactory;
import org.kefirsf.bb.conf.Code;
import org.kefirsf.bb.conf.Configuration;
import org.kefirsf.bb.conf.Pattern;
import org.kefirsf.bb.conf.PatternElement;
import org.kefirsf.bb.conf.Scope;
import org.kefirsf.bb.conf.Template;
import org.kefirsf.bb.proc.BBProcessor;
import org.kefirsf.bb.proc.ProcCode;
import org.kefirsf.bb.proc.ProcPattern;
import org.kefirsf.bb.proc.ProcPatternElement;
import org.kefirsf.bb.proc.ProcScope;
import org.kefirsf.bb.proc.ProcTemplate;

class ProcessorBuilder {
    private final PatternElementFactory patternElementFactory = new PatternElementFactory(this);
    private final TemplateElementFactory templateElementFactory = new TemplateElementFactory();
    private final Configuration conf;
    private Map<Scope, ProcScope> scopes;
    private Map<Code, ProcCode> codes;

    ProcessorBuilder(Configuration conf) {
        this.conf = conf;
    }

    public BBProcessor build() {
        this.scopes = new HashMap<Scope, ProcScope>();
        this.codes = new HashMap<Code, ProcCode>();
        this.patternElementFactory.cleanConstants();
        BBProcessor processor = new BBProcessor();
        processor.setScope(this.createScope(this.conf.getRootScope()));
        processor.setPrefix(this.createTemplate(this.conf.getPrefix()));
        processor.setSuffix(this.createTemplate(this.conf.getSuffix()));
        processor.setParams(this.conf.getParams());
        processor.setConstants(this.patternElementFactory.getConstants());
        processor.setNestingLimit(this.conf.getNestingLimit());
        processor.setPropagateNestingException(this.conf.isPropagateNestingException());
        for (ProcScope scope : this.scopes.values()) {
            scope.init();
        }
        return processor;
    }

    ProcScope createScope(Scope scope) {
        ProcScope created = this.scopes.get(scope);
        if (created == null) {
            created = new ProcScope(scope.getName());
            this.scopes.put(scope, created);
            created.setStrong(scope.isStrong());
            created.setIgnoreText(scope.isIgnoreText());
            if (scope.getParent() != null) {
                created.setParent(this.createScope(scope.getParent()));
            }
            HashSet<ProcCode> scopeCodes = new HashSet<ProcCode>();
            for (Code code : scope.getCodes()) {
                scopeCodes.add(this.createCode(code));
            }
            created.setScopeCodes(scopeCodes);
            created.setMin(scope.getMin());
            created.setMax(scope.getMax());
        }
        return created;
    }

    private ProcCode createCode(Code defCode) {
        if (!defCode.hasPatterns()) {
            throw new IllegalStateException("Field pattern can't be null.");
        }
        if (defCode.getTemplate() == null) {
            throw new IllegalStateException("Field template can't be null.");
        }
        ProcCode code = this.codes.get(defCode);
        if (code == null) {
            List<Pattern> confPatterns = defCode.getPatterns();
            ArrayList<ProcPattern> procPatterns = new ArrayList<ProcPattern>(confPatterns.size());
            for (Pattern confPattern : confPatterns) {
                procPatterns.add(this.createPattern(confPattern));
            }
            code = new ProcCode(procPatterns, this.createTemplate(defCode.getTemplate()), defCode.getName(), defCode.getPriority(), defCode.isTransparent());
            this.codes.put(defCode, code);
        }
        return code;
    }

    private ProcTemplate createTemplate(Template template) {
        if (!template.isEmpty()) {
            return new ProcTemplate(this.templateElementFactory.createTemplateList(template.getElements()));
        }
        return ProcTemplate.EMPTY;
    }

    private ProcPattern createPattern(Pattern pattern) {
        if (pattern.isEmpty()) {
            throw new IllegalStateException("Pattern elements list can't be empty.");
        }
        ArrayList<ProcPatternElement> elements = new ArrayList<ProcPatternElement>();
        for (PatternElement element : pattern.getElements()) {
            elements.add(this.patternElementFactory.create(element));
        }
        return new ProcPattern(elements);
    }
}

