/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.kefirsf.bb.ProcessorBuilder;
import org.kefirsf.bb.TextProcessorFactoryException;
import org.kefirsf.bb.conf.Action;
import org.kefirsf.bb.conf.BlankLine;
import org.kefirsf.bb.conf.Bol;
import org.kefirsf.bb.conf.Constant;
import org.kefirsf.bb.conf.Email;
import org.kefirsf.bb.conf.Eol;
import org.kefirsf.bb.conf.Junk;
import org.kefirsf.bb.conf.PatternElement;
import org.kefirsf.bb.conf.Scope;
import org.kefirsf.bb.conf.Text;
import org.kefirsf.bb.conf.Url;
import org.kefirsf.bb.conf.Variable;
import org.kefirsf.bb.proc.Check;
import org.kefirsf.bb.proc.PatternConstant;
import org.kefirsf.bb.proc.PatternJunk;
import org.kefirsf.bb.proc.ProcBlankLine;
import org.kefirsf.bb.proc.ProcBol;
import org.kefirsf.bb.proc.ProcEmail;
import org.kefirsf.bb.proc.ProcEol;
import org.kefirsf.bb.proc.ProcPatternElement;
import org.kefirsf.bb.proc.ProcText;
import org.kefirsf.bb.proc.ProcUrl;
import org.kefirsf.bb.proc.ProcVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PatternElementFactory {
    private static final ProcBol PROC_BOL = new ProcBol();
    private static final PatternJunk JUNK = new PatternJunk();
    private static final ProcEol EOL = new ProcEol(false);
    private static final ProcEol EOL_GHOST = new ProcEol(true);
    private static final ProcBlankLine BLANK_LINE = new ProcBlankLine(false);
    private static final ProcBlankLine BLANK_LINE_GHOST = new ProcBlankLine(true);
    private final ProcessorBuilder processorBuilder;
    private Map<Constant, PatternConstant> constants;

    PatternElementFactory(ProcessorBuilder processorBuilder) {
        this.processorBuilder = processorBuilder;
    }

    ProcPatternElement create(PatternElement element) {
        if (element instanceof Variable) {
            return this.create((Variable)element);
        }
        if (element instanceof Text) {
            return this.create((Text)element);
        }
        if (element instanceof Constant) {
            return this.create((Constant)element);
        }
        if (element instanceof Junk) {
            return JUNK;
        }
        if (element instanceof Eol) {
            return ((Eol)element).isGhost() ? EOL_GHOST : EOL;
        }
        if (element instanceof Bol) {
            return PROC_BOL;
        }
        if (element instanceof BlankLine) {
            return ((BlankLine)element).isGhost() ? BLANK_LINE_GHOST : BLANK_LINE;
        }
        if (element instanceof Url) {
            Url url = (Url)element;
            return new ProcUrl(url.getName(), url.isGhost(), url.isLocal(), url.isSchemaless());
        }
        if (element instanceof Email) {
            Email email = (Email)element;
            return new ProcEmail(email.getName(), email.isGhost());
        }
        throw new TextProcessorFactoryException("Unknown pattern element " + element.getClass().getName() + ".");
    }

    private ProcPatternElement create(Variable variable) {
        if (variable.getAction() != Action.check) {
            return new ProcVariable(variable.getName(), variable.getRegex(), variable.isGhost(), variable.getAction());
        }
        return new Check(variable.getName(), variable.isGhost());
    }

    private PatternConstant create(Constant constant) {
        if (!this.constants.containsKey(constant)) {
            this.constants.put(constant, new PatternConstant(constant.getValue(), constant.isIgnoreCase(), constant.isGhost()));
        }
        return this.constants.get(constant);
    }

    private ProcPatternElement create(Text text) {
        Scope scope = text.getScope();
        if (scope != null) {
            return new ProcText(text.getName(), this.processorBuilder.createScope(scope), text.isTransparent());
        }
        return new ProcText(text.getName(), text.isTransparent());
    }

    HashSet<PatternConstant> getConstants() {
        return new HashSet<PatternConstant>(this.constants.values());
    }

    void cleanConstants() {
        this.constants = new HashMap<Constant, PatternConstant>();
    }
}

