/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb;

import java.util.Arrays;
import org.kefirsf.bb.TextProcessorAdapter;

public class EscapeProcessor
extends TextProcessorAdapter {
    private final String[][] escape;

    public EscapeProcessor(String[][] escape) {
        this.escape = escape;
    }

    public CharSequence process(CharSequence source) {
        if (source != null && source.length() > 0) {
            String stringSource = source instanceof String ? (String)source : ((Object)source).toString();
            int[] indexes = new int[this.escape.length];
            Arrays.fill(indexes, -1);
            int length = source.length();
            int offset = 0;
            StringBuilder result = new StringBuilder(length);
            while (offset < length) {
                int escPosition = -1;
                int escIndex = -1;
                for (int i = 0; i < this.escape.length; ++i) {
                    int index;
                    if (indexes[i] < offset) {
                        indexes[i] = index = stringSource.indexOf(this.escape[i][0], offset);
                    } else {
                        index = indexes[i];
                    }
                    if (index < 0 || index >= escPosition && escPosition >= 0) continue;
                    escPosition = index;
                    escIndex = i;
                }
                if (escPosition >= 0) {
                    result.append(stringSource, offset, escPosition);
                    result.append(this.escape[escIndex][1]);
                    offset = escPosition + this.escape[escIndex][0].length();
                    continue;
                }
                result.append(stringSource, offset, length);
                offset = length;
            }
            return result;
        }
        return new StringBuilder(0);
    }
}

