/*
 * Decompiled with CFR 0.152.
 */
package org.kasource.web.websocket.listener;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.EnumSet;
import org.kasource.web.websocket.WebSocketEventListener;
import org.kasource.web.websocket.event.WebSocketEvent;
import org.kasource.web.websocket.event.WebSocketEventType;

public class WebSocketEventMethod
implements WebSocketEventListener {
    private Object listener;
    private Method method;
    private EnumSet<WebSocketEventType> filters;

    public WebSocketEventMethod(Object listener, Method method, WebSocketEventType ... filter) {
        if (method.isAccessible()) {
            throw new IllegalArgumentException("WebSocket Event Listener method must be public");
        }
        Class<?>[] params = method.getParameterTypes();
        if (params.length != 1) {
            throw new IllegalArgumentException("WebSocket Event Listener method must have one parameter");
        }
        if (!WebSocketEvent.class.isAssignableFrom(params[0])) {
            throw new IllegalArgumentException("WebSocket Event Listeners method argument must be a WebSocketEvent or subclass thereof.");
        }
        this.method = method;
        this.listener = listener;
        if (filter.length != 0) {
            this.filters = EnumSet.copyOf(Arrays.asList(filter));
        }
    }

    @Override
    public void onWebSocketEvent(WebSocketEvent event) {
        try {
            if (this.filters == null || this.filters.isEmpty()) {
                this.method.invoke(this.listener, event);
            } else if (this.filters.contains((Object)event.getType())) {
                this.method.invoke(this.listener, event);
            }
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }
}

