/*
 * Decompiled with CFR 0.152.
 */
package org.kasource.web.websocket.impl.tomcat;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.websocket.StreamInbound;
import org.apache.catalina.websocket.WebSocketServlet;
import org.kasource.web.websocket.WebSocketImpl;
import org.kasource.web.websocket.WebSocketManager;
import org.kasource.web.websocket.WebSocketManagerRepository;
import org.kasource.web.websocket.impl.tomcat.TomcatWebSocketClient;
import org.kasource.web.websocket.impl.tomcat.TomcatWebSocketManager;
import org.kasource.web.websocket.util.ClientIdGenerator;

public class TomcatWebsocketImpl
extends WebSocketServlet
implements WebSocketManagerRepository {
    private static final String ATTRIBUTE_PREFIX = WebSocketImpl.class.getPackage().getName() + ".";
    private static final long serialVersionUID = 1L;
    private Map<String, TomcatWebSocketManager> managers = new ConcurrentHashMap<String, TomcatWebSocketManager>();
    private static final String DEFAULT_CLIENT_ID_PARAMETER = "username";
    private int outboundByteBufferSize;
    private int outboundCharBufferSize;
    private Set<String> orginWhiteList = new HashSet<String>();
    private String clientIdParameter = "username";
    private ClientIdGenerator idGeneator;
    private boolean dynamicAddressing;

    public TomcatWebsocketImpl() {
        System.out.println("TomcatWebsocketImpl started");
    }

    public void init() throws ServletException {
        String clientId;
        super.init();
        this.outboundByteBufferSize = this.parseInitParamAsInt("outboundByteBufferSize");
        this.outboundCharBufferSize = this.parseInitParamAsInt("outboundCharBufferSize");
        String orgins = this.getInitParameter("orginWhiteList");
        if (orgins != null && !orgins.isEmpty()) {
            String[] orginArr = orgins.split(",");
            this.orginWhiteList.addAll(Arrays.asList(orginArr));
        }
        if ((clientId = this.getInitParameter("clientIdParameter")) != null && !clientId.isEmpty()) {
            this.clientIdParameter = clientId;
        }
        this.idGeneator = new ClientIdGenerator(this.clientIdParameter);
        this.setDymamicAddressing();
        if (!this.dynamicAddressing) {
            this.getWebSocketManager(this.getServletName());
        }
    }

    private void setDymamicAddressing() {
        String dynamic = this.getInitParameter("dynamicAddressing");
        this.dynamicAddressing = dynamic != null && dynamic.toLowerCase().trim().equals("true");
    }

    private int parseInitParamAsInt(String param) throws ServletException {
        String paramValue = this.getInitParameter(param);
        try {
            if (paramValue != null && !paramValue.isEmpty()) {
                return Integer.parseInt(paramValue);
            }
        }
        catch (NumberFormatException nfe) {
            throw new ServletException(param + " must be an integer value.", (Throwable)nfe);
        }
        return 0;
    }

    protected StreamInbound createWebSocketInbound(String subProtocol, HttpServletRequest request) {
        String managerName = this.getServletName();
        if (this.dynamicAddressing) {
            managerName = request.getRequestURI().substring(request.getContextPath().length());
        }
        TomcatWebSocketManager manager = (TomcatWebSocketManager)this.getWebSocketManager(managerName);
        String id = this.idGeneator.getId(request, manager);
        TomcatWebSocketClient client = new TomcatWebSocketClient(manager, id, request.getParameterMap());
        if (this.outboundByteBufferSize != 0) {
            client.setOutboundByteBufferSize(this.outboundByteBufferSize);
        }
        if (this.outboundCharBufferSize != 0) {
            client.setOutboundCharBufferSize(this.outboundCharBufferSize);
        }
        return client;
    }

    @Override
    public WebSocketManager getWebSocketManager(String socketName) {
        if (!this.managers.containsKey(socketName)) {
            TomcatWebSocketManager manager = new TomcatWebSocketManager();
            this.managers.put(socketName, manager);
            this.getServletContext().setAttribute(ATTRIBUTE_PREFIX + socketName, (Object)manager);
            return manager;
        }
        return this.managers.get(socketName);
    }

    protected boolean verifyOrigin(String origin) {
        if (origin == null) {
            return false;
        }
        if (!this.orginWhiteList.isEmpty()) {
            return this.orginWhiteList.contains(origin);
        }
        return true;
    }
}

