/*
 * Decompiled with CFR 0.152.
 */
package org.kasource.web.websocket.impl.tomcat;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Map;
import org.apache.catalina.websocket.StreamInbound;
import org.apache.catalina.websocket.WsOutbound;
import org.kasource.web.websocket.impl.WebSocketClient;
import org.kasource.web.websocket.impl.tomcat.TomcatWebSocketManager;
import org.kasource.web.websocket.util.IoUtils;

public class TomcatWebSocketClient
extends StreamInbound
implements WebSocketClient {
    private TomcatWebSocketManager manager;
    private Map<String, String[]> connectionParameters;
    private String id;
    private IoUtils ioUtils = new IoUtils();

    protected TomcatWebSocketClient(TomcatWebSocketManager manager, String clientId, Map<String, String[]> connectionParameters) {
        this.connectionParameters = connectionParameters;
        this.manager = manager;
        this.id = clientId;
    }

    protected void onBinaryData(InputStream is) throws IOException {
        this.manager.onWebSocketMessage(this.ioUtils.toByteArray(is), this.id);
    }

    protected void onTextData(Reader r) throws IOException {
        this.manager.onWebSocketMessage(this.ioUtils.readString(r), this.id);
    }

    protected void onOpen(WsOutbound outbound) {
        this.manager.registerClient(this.id, this, this.connectionParameters);
    }

    protected void onClose(int status) {
        this.manager.unregisterClient(this.id);
    }

    @Override
    public void sendMessageToSocket(String message) {
        try {
            this.getWsOutbound().writeTextMessage(CharBuffer.wrap(message));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void sendMessageToSocket(byte[] message) {
        try {
            this.getWsOutbound().writeBinaryMessage(ByteBuffer.wrap(message));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

