/*
 * Decompiled with CFR 0.152.
 */
package org.kasource.web.websocket.impl.jetty;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketServlet;
import org.kasource.web.websocket.WebSocketImpl;
import org.kasource.web.websocket.WebSocketManager;
import org.kasource.web.websocket.WebSocketManagerRepository;
import org.kasource.web.websocket.impl.jetty.JettyWebSocketClient;
import org.kasource.web.websocket.impl.jetty.JettyWebSocketManager;
import org.kasource.web.websocket.util.ClientIdGenerator;

public class JettyWebSocketImpl
extends WebSocketServlet
implements WebSocketManagerRepository {
    private static final String ATTRIBUTE_PREFIX = WebSocketImpl.class.getPackage().getName() + ".";
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_CLIENT_ID_PARAMETER = "username";
    private Map<String, JettyWebSocketManager> managers = new ConcurrentHashMap<String, JettyWebSocketManager>();
    private Set<String> orginWhiteList = new HashSet<String>();
    private String clientIdParameter = "username";
    private ClientIdGenerator idGeneator;
    private boolean dynamicAddressing;

    public void init() throws ServletException {
        String clientId;
        super.init();
        String orgins = this.getInitParameter("orginWhiteList");
        if (orgins != null && !orgins.isEmpty()) {
            String[] orginArr = orgins.split(",");
            this.orginWhiteList.addAll(Arrays.asList(orginArr));
        }
        if ((clientId = this.getInitParameter("clientIdParameter")) != null && !clientId.isEmpty()) {
            this.clientIdParameter = clientId;
        }
        this.idGeneator = new ClientIdGenerator(this.clientIdParameter);
        this.setDymamicAddressing();
        if (!this.dynamicAddressing) {
            this.getWebSocketManager(this.getServletName());
        }
    }

    private void setDymamicAddressing() {
        String dynamic = this.getInitParameter("dynamicAddressing");
        this.dynamicAddressing = dynamic != null && dynamic.toLowerCase().trim().equals("true");
    }

    public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
        String managerName = this.getServletName();
        if (this.dynamicAddressing) {
            managerName = request.getRequestURI().substring(request.getContextPath().length());
        }
        JettyWebSocketManager manager = (JettyWebSocketManager)this.getWebSocketManager(managerName);
        String clientId = this.idGeneator.getId(request, manager);
        return new JettyWebSocketClient(manager, clientId, request.getParameterMap());
    }

    public boolean checkOrigin(HttpServletRequest request, String origin) {
        if (origin == null) {
            return false;
        }
        if (!this.orginWhiteList.isEmpty()) {
            return this.orginWhiteList.contains(origin);
        }
        return true;
    }

    @Override
    public WebSocketManager getWebSocketManager(String socketName) {
        if (!this.managers.containsKey(socketName)) {
            JettyWebSocketManager manager = new JettyWebSocketManager();
            this.managers.put(socketName, manager);
            this.getServletContext().setAttribute(ATTRIBUTE_PREFIX + socketName, (Object)manager);
            return manager;
        }
        return this.managers.get(socketName);
    }
}

