/*
 * Decompiled with CFR 0.152.
 */
package org.kasource.web.websocket.impl.glassfish;

import java.util.Map;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.DefaultWebSocket;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocketListener;
import org.kasource.web.websocket.impl.WebSocketClient;
import org.kasource.web.websocket.impl.glassfish.GlassFishWebSocketManager;

public class GlassFishWebSocketClient
extends DefaultWebSocket
implements WebSocketClient {
    private GlassFishWebSocketManager manager;
    private String id;
    private Map<String, String[]> connectionParameters;

    public GlassFishWebSocketClient(GlassFishWebSocketManager manager, ProtocolHandler protocolHandler, HttpRequestPacket request, WebSocketListener[] listeners, String clientId, Map<String, String[]> connectionParameters) {
        super(protocolHandler, request, listeners);
        this.connectionParameters = connectionParameters;
        this.manager = manager;
        this.id = clientId;
    }

    public void onClose(DataFrame frame) {
        super.onClose(frame);
        this.manager.unregisterClient(this.id);
    }

    public void onConnect() {
        super.onConnect();
        this.manager.registerClient(this.id, this, this.connectionParameters);
    }

    public void onMessage(String text) {
        super.onMessage(text);
        this.manager.onWebSocketMessage(text, this.id);
    }

    public void onMessage(byte[] bytes) {
        super.onMessage(bytes);
        this.manager.onWebSocketMessage(bytes, this.id);
    }

    @Override
    public void sendMessageToSocket(String message) {
        super.send(message);
    }

    @Override
    public void sendMessageToSocket(byte[] message) {
        super.send(message);
    }
}

