/*
 * Decompiled with CFR 0.152.
 */
package org.kasource.web.websocket.impl.glassfish;

import java.io.CharConversionException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.util.URLDecoder;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.WebSocketEngine;
import org.glassfish.grizzly.websockets.WebSocketListener;
import org.kasource.web.websocket.WebSocketImpl;
import org.kasource.web.websocket.WebSocketManager;
import org.kasource.web.websocket.impl.glassfish.GlassFishWebSocketClient;
import org.kasource.web.websocket.impl.glassfish.GlassFishWebSocketManager;

public class GlassFishWebSocket
extends WebSocketApplication {
    private static final String ATTRIBUTE_PREFIX = WebSocketImpl.class.getPackage().getName() + ".";
    private static final String DEFAULT_CLIENT_ID_PARAMETER = "username";
    private String clientIdParameter = "username";
    private ServletContext servletContext;
    private Map<String, GlassFishWebSocketManager> managers = new ConcurrentHashMap<String, GlassFishWebSocketManager>();

    public void initialize() {
        WebSocketEngine.getEngine().register((WebSocketApplication)this);
    }

    public boolean isApplicationRequest(HttpRequestPacket request) {
        return true;
    }

    public WebSocket createSocket(ProtocolHandler handler, HttpRequestPacket requestPacket, WebSocketListener ... listeners) {
        String clientId;
        String socketName = this.getLastPathElement(requestPacket);
        GlassFishWebSocketManager manager = (GlassFishWebSocketManager)this.getWebSocketManager(socketName);
        String id = clientId = this.getParamterValue(requestPacket, this.clientIdParameter);
        int i = 0;
        while (manager.hasClient(id)) {
            id = clientId + "-" + i;
        }
        if (clientId == null) {
            clientId = UUID.randomUUID().toString().replace("-", "").toUpperCase();
        }
        return new GlassFishWebSocketClient(manager, handler, requestPacket, listeners, id, this.getParamterMap(requestPacket));
    }

    public WebSocketManager getWebSocketManager(String socketName) {
        if (!this.managers.containsKey(socketName)) {
            GlassFishWebSocketManager manager = new GlassFishWebSocketManager();
            this.managers.put(socketName, manager);
            this.servletContext.setAttribute(ATTRIBUTE_PREFIX + socketName, (Object)manager);
            return manager;
        }
        return this.managers.get(socketName);
    }

    private String getLastPathElement(HttpRequestPacket requestPacket) {
        int index = requestPacket.getRequestURI().lastIndexOf(47);
        return requestPacket.getRequestURI().substring(index + 1);
    }

    private String getParamterValue(HttpRequestPacket requestPacket, String paramterName) {
        String[] parameters;
        String queryString;
        String clientId = null;
        try {
            queryString = URLDecoder.decode((String)requestPacket.getQueryString());
        }
        catch (CharConversionException e) {
            return null;
        }
        if (queryString.startsWith("?")) {
            queryString = queryString.substring(1);
        }
        for (String parameter : parameters = queryString.split("&")) {
            String[] paratmeterParts = parameter.split("=");
            if (!paratmeterParts[0].trim().equals(paramterName)) continue;
            clientId = paratmeterParts[1].trim();
        }
        return clientId;
    }

    private Map<String, String[]> getParamterMap(HttpRequestPacket requestPacket) {
        String[] parameters;
        String queryString;
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        try {
            queryString = URLDecoder.decode((String)requestPacket.getQueryString());
        }
        catch (CharConversionException e) {
            return params;
        }
        if (queryString.startsWith("?")) {
            queryString = queryString.substring(1);
        }
        for (String parameter : parameters = queryString.split("&")) {
            String[] paratmeterParts = parameter.split("=");
            String key = paratmeterParts[0].trim();
            String value = paratmeterParts[1].trim();
            String[] values = (String[])params.get(key);
            if (values == null) {
                params.put(key, new String[]{value});
                continue;
            }
            String[] newValues = new String[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            newValues[values.length] = value;
            params.put(key, newValues);
        }
        return params;
    }

    public void setClientIdParameter(String clientIdParameter) {
        this.clientIdParameter = clientIdParameter;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

