/*
 * Decompiled with CFR 0.152.
 */
package org.kasource.web.websocket.impl;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.kasource.web.websocket.NoSuchWebSocketClient;
import org.kasource.web.websocket.WebSocketEventListener;
import org.kasource.web.websocket.WebSocketManager;
import org.kasource.web.websocket.WebSocketMessageListener;
import org.kasource.web.websocket.event.WebSocketClientConnectionEvent;
import org.kasource.web.websocket.event.WebSocketClientEvent;
import org.kasource.web.websocket.event.WebSocketEventType;
import org.kasource.web.websocket.impl.WebSocketClient;

public abstract class AbstractWebSocketManager
implements WebSocketManager {
    private Map<String, WebSocketClient> clients = new ConcurrentHashMap<String, WebSocketClient>();
    private Set<WebSocketMessageListener> webSocketMessageListeners = new HashSet<WebSocketMessageListener>();
    private Set<WebSocketEventListener> webSocketEventListeners = new HashSet<WebSocketEventListener>();

    @Override
    public void broadcast(String message) {
        for (WebSocketClient client : this.clients.values()) {
            client.sendMessageToSocket(message);
        }
    }

    @Override
    public void broadcastBinary(byte[] message) {
        for (WebSocketClient client : this.clients.values()) {
            client.sendMessageToSocket(message);
        }
    }

    @Override
    public void sendMessage(String clientId, String message) throws IOException, NoSuchWebSocketClient {
        WebSocketClient client = this.clients.get(clientId);
        if (client == null) {
            throw new NoSuchWebSocketClient("No client found with ID " + clientId);
        }
        client.sendMessageToSocket(message);
    }

    @Override
    public void sendBinaryMessage(String clientId, byte[] message) throws IOException, NoSuchWebSocketClient {
        WebSocketClient client = this.clients.get(clientId);
        if (client == null) {
            throw new NoSuchWebSocketClient("No client found with ID " + clientId);
        }
        client.sendMessageToSocket(message);
    }

    @Override
    public void addWebSocketMessageListener(WebSocketMessageListener webSocketMessageListener) {
        this.webSocketMessageListeners.add(webSocketMessageListener);
    }

    @Override
    public void addWebSocketEventListener(WebSocketEventListener webSocketEventListener) {
        this.webSocketEventListeners.add(webSocketEventListener);
    }

    public void registerClient(String id, WebSocketClient client, Map<String, String[]> connectionParameters) {
        this.clients.put(id, client);
        if (!this.webSocketEventListeners.isEmpty()) {
            this.sendEvent(new WebSocketClientConnectionEvent(this, WebSocketEventType.CLIENT_CONNECTED, id, connectionParameters));
        }
    }

    public void unregisterClient(String id) {
        this.clients.remove(id);
        if (!this.webSocketEventListeners.isEmpty()) {
            this.sendEvent(new WebSocketClientEvent(this, WebSocketEventType.CLIENT_DISCONNECTED, id));
        }
    }

    private void sendEvent(WebSocketClientEvent event) {
        for (WebSocketEventListener listener : this.webSocketEventListeners) {
            listener.onWebSocketEvent(event);
        }
    }

    public void onWebSocketMessage(String message, String id) {
        if (!this.webSocketMessageListeners.isEmpty()) {
            for (WebSocketMessageListener listener : this.webSocketMessageListeners) {
                listener.onMessage(message, id);
            }
        }
    }

    public void onWebSocketMessage(byte[] message, String id) {
        if (!this.webSocketMessageListeners.isEmpty()) {
            for (WebSocketMessageListener listener : this.webSocketMessageListeners) {
                listener.onBinaryMessage(message, id);
            }
        }
    }

    public boolean hasClient(String id) {
        return this.clients.containsKey(id);
    }
}

