/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.test.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.kaazing.test.util.MemoryAppender;

public class MethodExecutionTrace
extends TestWatcher {
    private static final int _1_MB = 0x100000;
    private static final int MAX_HEALTH_MEMORY_MB = 1024;
    private long start;

    public MethodExecutionTrace() {
        this("log4j-trace.properties");
    }

    public MethodExecutionTrace(String log4jPropertiesResourceName) {
        this.healthCheck();
        MemoryAppender.initialize();
        if (log4jPropertiesResourceName != null) {
            Properties log4j = new Properties();
            try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(log4jPropertiesResourceName);){
                if (in == null) {
                    throw new RuntimeException(String.format("Could not load resource %s", log4jPropertiesResourceName));
                }
                log4j.load(in);
                PropertyConfigurator.configure((Properties)log4j);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Could not load resource %s", log4jPropertiesResourceName), e);
            }
        }
    }

    public MethodExecutionTrace(Properties log4jProperties) {
        MemoryAppender.initialize();
        if (log4jProperties != null) {
            PropertyConfigurator.configure((Properties)log4jProperties);
        }
    }

    public void starting(Description description) {
        this.start = System.currentTimeMillis();
        System.out.println(description.getDisplayName() + " starting");
    }

    public void failed(Throwable e, Description description) {
        if (e instanceof AssumptionViolatedException) {
            System.out.println(String.format("%s skipped programmatically with reason: %s", this.getFullMethodName(description), e.getMessage()));
        } else {
            System.out.println(this.getFullMethodName(description) + " FAILED with exception " + e + this.getDuration());
            e.printStackTrace(System.out);
            System.out.println("=================== BEGIN STORED LOG MESSAGES ===========================");
            MemoryAppender.printAllMessages();
            System.out.println("=================== END STORED LOG MESSAGES ===========================");
        }
        MemoryAppender.initialize();
    }

    public void succeeded(Description description) {
        System.out.println(this.getFullMethodName(description) + " success" + this.getDuration());
        MemoryAppender.initialize();
    }

    private String getFullMethodName(Description description) {
        return description.getTestClass().getSimpleName() + "." + description.getMethodName();
    }

    private String getDuration() {
        float t = (float)(System.currentTimeMillis() - this.start) / 1000.0f;
        return String.format(" (%4.2f secs)", Float.valueOf(t));
    }

    private void healthCheck() {
        Runtime r = Runtime.getRuntime();
        long memory = r.totalMemory() / 0x100000L;
        long free = r.freeMemory() / 0x100000L;
        long used = memory - free;
        int threads = Thread.activeCount();
        if (used > 1024L || threads > 100) {
            System.out.println("HEALTH CHECK WARNING: high memory usage or thread count");
            System.out.println(String.format("\tMemory: total %d MB, free %d MB", memory, free));
            System.out.println(String.format("\tThreads: %d", Thread.activeCount()));
        }
    }
}

