/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.test.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Queue;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.junit.Assert;

public class MemoryAppender
extends ConsoleAppender {
    private static final boolean DEBUG = false;
    private static Queue<LoggingEvent> eventsList = new LinkedBlockingQueue<LoggingEvent>();
    private static MemoryAppender lastInstance;
    private static int MAX_MESSAGES;
    private static AtomicInteger messageCount;
    private static String gatewayBeingStarted;
    private boolean printNow;
    private String gatewayName;

    public static void initialize() {
        eventsList.clear();
        lastInstance = null;
        messageCount.set(0);
        gatewayBeingStarted = null;
    }

    private static Queue<LoggingEvent> getEvents() {
        return eventsList;
    }

    public static void assertLogMessages(Collection<String> expectedPatternsRO, Collection<String> unexpectedPatterns, Collection<Class<? extends Throwable>> expectedExceptionsRO, Collection<Class<? extends Throwable>> unexpectedExceptions, String filterPattern, boolean verbose) {
        TreeSet<String> encounteredPatterns = new TreeSet<String>();
        ArrayList<String> encounteredUnexpectedMessages = new ArrayList<String>();
        ArrayList<String> expectedPatterns = expectedPatternsRO == null ? Collections.emptyList() : new ArrayList<String>(expectedPatternsRO);
        unexpectedPatterns = unexpectedPatterns == null ? Collections.emptyList() : unexpectedPatterns;
        TreeSet<Throwable> encounteredExceptions = new TreeSet<Throwable>();
        ArrayList<Throwable> encounteredUnexpectedExceptions = new ArrayList<Throwable>();
        ArrayList<Class<? extends Throwable>> expectedExceptions = expectedExceptionsRO == null ? Collections.emptyList() : new ArrayList<Class<? extends Throwable>>(expectedExceptionsRO);
        unexpectedExceptions = unexpectedExceptions == null ? Collections.emptyList() : unexpectedExceptions;
        for (LoggingEvent event : MemoryAppender.getEvents()) {
            String pattern;
            Throwable t;
            String message = event.getMessage().toString();
            if (filterPattern != null && !message.matches(filterPattern)) continue;
            ThrowableInformation ti = event.getThrowableInformation();
            Throwable throwable = t = ti != null && ti.getThrowable() != null ? ti.getThrowable() : null;
            if (verbose) {
                System.out.println(event.getLevel() + " " + message + " " + t);
            }
            Iterator<Object> iterator = expectedPatterns.iterator();
            while (iterator.hasNext()) {
                pattern = (String)iterator.next();
                if (!message.matches("(?s).*" + pattern + ".*")) continue;
                encounteredPatterns.add(pattern);
                iterator.remove();
            }
            iterator = unexpectedPatterns.iterator();
            while (iterator.hasNext()) {
                pattern = (String)iterator.next();
                if (!message.matches("(?s).*" + pattern + ".*")) continue;
                encounteredUnexpectedMessages.add(message);
            }
            if (t == null) continue;
            for (Class clazz : expectedExceptions) {
                if (clazz != t.getClass()) continue;
                encounteredExceptions.add(t);
                iterator.remove();
            }
            for (Class clazz : unexpectedExceptions) {
                if (clazz != t.getClass()) continue;
                encounteredUnexpectedExceptions.add(t);
            }
        }
        StringBuffer errorMessage = new StringBuffer();
        if (!encounteredUnexpectedMessages.isEmpty()) {
            errorMessage.append("\n- the following unexpected messages were encountered: ");
            for (String message : encounteredUnexpectedMessages) {
                errorMessage.append("\n  " + message);
            }
        }
        if (!expectedPatterns.isEmpty()) {
            errorMessage.append("\n- the following patterns of log messages were not logged: " + expectedPatterns + (verbose ? ",\nonly these were logged: " + encounteredPatterns : ""));
        }
        if (!encounteredUnexpectedExceptions.isEmpty()) {
            errorMessage.append("\n- the following unexpected exceptions were encountered: ");
            for (Throwable exception : encounteredUnexpectedExceptions) {
                errorMessage.append("\n  " + exception);
            }
        }
        if (!expectedExceptions.isEmpty()) {
            errorMessage.append("\n- the following exceptions were not logged: " + expectedPatterns + (verbose ? ",\nonly these were logged: " + encounteredExceptions : ""));
        }
        Assert.assertTrue((String)("Log messages were not as expected" + errorMessage.toString()), (expectedPatterns.isEmpty() && encounteredUnexpectedMessages.isEmpty() && expectedExceptions.isEmpty() && encounteredUnexpectedExceptions.isEmpty() ? 1 : 0) != 0);
    }

    public static void assertMessagesLogged(Collection<String> expectedPatternsRO, Collection<String> unexpectedPatterns, String filterPattern, boolean verbose) {
        MemoryAppender.assertLogMessages(expectedPatternsRO, unexpectedPatterns, null, null, filterPattern, verbose);
    }

    public static void printAllMessages() {
        if (lastInstance == null) {
            System.out.println("Unable to print out trace level root logger messages - please configure MemoryAppender on the <root> logger in log4j - config.xml");
        } else {
            System.out.println(String.format("Printing last %d of %d log messages", eventsList.size(), messageCount.get()));
            lastInstance.appendAll();
        }
    }

    public static void setGatewayBeingStarted(String gatewayName) {
        gatewayBeingStarted = gatewayName;
    }

    public MemoryAppender() {
        lastInstance = this;
        this.gatewayName = gatewayBeingStarted;
        this.debug("MemoryAppender instance " + this.toString() + " created");
    }

    protected void subAppend(LoggingEvent event) {
        if (this.printNow) {
            super.subAppend(event);
        } else {
            event.getThreadName();
            if (this.gatewayName != null) {
                this.injectGatewayName(event);
            }
            eventsList.add(event);
            if (messageCount.incrementAndGet() > MAX_MESSAGES) {
                eventsList.poll();
            }
        }
    }

    public void close() {
        this.debug("MemoryAppender instance " + (Object)((Object)this) + " closed");
    }

    public boolean requiresLayout() {
        return true;
    }

    public String toString() {
        String ret = super.toString();
        ret = ret + (this.gatewayName == null ? "" : " for gateway " + this.gatewayName);
        return ret;
    }

    private void appendAll() {
        this.printNow = true;
        try {
            for (LoggingEvent event : eventsList) {
                super.append(event);
            }
        }
        finally {
            eventsList.clear();
        }
        this.printNow = false;
    }

    private void debug(String message) {
    }

    private void injectGatewayName(LoggingEvent event) {
        if (!this.injectGatewayName(event, "renderedMessage")) {
            this.injectGatewayName(event, "message");
        }
    }

    private boolean injectGatewayName(LoggingEvent event, String fieldName) {
        try {
            Field field = LoggingEvent.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            String oldMessage = (String)field.get(event);
            if (oldMessage != null) {
                String newMessage = String.format("[%s gateway] %s", this.gatewayName, oldMessage);
                field.set(event, newMessage);
                if (oldMessage.contains("Started server successfully in ")) {
                    this.gatewayName = null;
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            System.out.println((Object)((Object)this) + ": caught exception " + e);
            return true;
        }
    }

    static {
        MAX_MESSAGES = 30000;
        messageCount = new AtomicInteger(0);
        MemoryAppender.initialize();
    }
}

