/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.test.util;

import java.lang.reflect.Field;
import java.util.concurrent.TimeUnit;
import org.junit.internal.runners.statements.InvokeMethod;
import org.junit.rules.DisableOnDebug;
import org.junit.rules.MethodRule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.kaazing.k3po.junit.rules.K3poRule;
import org.kaazing.test.util.MethodExecutionTrace;

public final class ITUtil {
    private static final Field FIELD_TARGET;
    private static final Field FIELD_FRAMEWORK_METHOD;

    public static RuleChain createRuleChain(TestRule gateway, K3poRule robot) {
        return ITUtil.createRuleChain(gateway, robot, 10L, TimeUnit.SECONDS);
    }

    public static RuleChain createRuleChain(TestRule gateway, K3poRule robot, long timeout, TimeUnit timeUnit) {
        MethodExecutionTrace trace = new MethodExecutionTrace();
        DisableOnDebug timeoutRule = new DisableOnDebug((TestRule)Timeout.builder().withTimeout(timeout, timeUnit).withLookingForStuckThread(true).build());
        return RuleChain.outerRule((TestRule)trace).around(gateway).around((TestRule)robot).around((TestRule)timeoutRule);
    }

    public static RuleChain createRuleChain(TestRule gateway, long timeout, TimeUnit timeUnit) {
        MethodExecutionTrace trace = new MethodExecutionTrace();
        DisableOnDebug timeoutRule = new DisableOnDebug((TestRule)Timeout.builder().withTimeout(timeout, timeUnit).withLookingForStuckThread(true).build());
        return RuleChain.outerRule((TestRule)trace).around((TestRule)timeoutRule).around(gateway);
    }

    public static RuleChain createRuleChain(long timeout, TimeUnit timeUnit) {
        TestRule timeoutRule = ITUtil.timeoutRule(timeout, timeUnit);
        MethodExecutionTrace trace = new MethodExecutionTrace();
        return RuleChain.outerRule((TestRule)trace).around(timeoutRule);
    }

    public static TestRule timeoutRule(long timeout, TimeUnit timeUnit) {
        return new DisableOnDebug((TestRule)Timeout.builder().withTimeout(timeout, timeUnit).withLookingForStuckThread(true).build());
    }

    public static TestRule toTestRule(final MethodRule in) {
        return new TestRule(){

            public Statement apply(Statement base, Description description) {
                if (base instanceof InvokeMethod) {
                    return this.doApplyInvokeMethod(in, base, (InvokeMethod)base);
                }
                return in.apply(base, null, (Object)description);
            }

            private Statement doApplyInvokeMethod(MethodRule in2, Statement base, InvokeMethod invokeMethod) {
                try {
                    FrameworkMethod frameworkMethod = (FrameworkMethod)FIELD_FRAMEWORK_METHOD.get(invokeMethod);
                    Object target = FIELD_TARGET.get(invokeMethod);
                    return in2.apply(base, frameworkMethod, target);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
    }

    private ITUtil() {
    }

    static {
        try {
            Field target = InvokeMethod.class.getDeclaredField("target");
            Field frameworkMethod = InvokeMethod.class.getDeclaredField("testMethod");
            target.setAccessible(true);
            frameworkMethod.setAccessible(true);
            FIELD_TARGET = target;
            FIELD_FRAMEWORK_METHOD = frameworkMethod;
        }
        catch (NoSuchFieldException | SecurityException ex) {
            throw new RuntimeException(ex);
        }
    }
}

