/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.test.util;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public final class ResolutionTestUtils {
    private ResolutionTestUtils() {
    }

    public static String getLoopbackInterface() {
        String networkInterface = "";
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface resolvedNetworkInterface = interfaces.nextElement();
                if (!resolvedNetworkInterface.isLoopback()) continue;
                networkInterface = resolvedNetworkInterface.getDisplayName();
                break;
            }
            if (networkInterface.equals("")) {
                throw new RuntimeException("No loopback interfaces could be found");
            }
        }
        catch (SocketException socketEx) {
            throw new RuntimeException("No interfaces could be found");
        }
        return networkInterface;
    }
}

