/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.test.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.kaazing.test.util.MemoryAppender;

public class MethodExecutionTrace
extends TestWatcher {
    public MethodExecutionTrace() {
        this("log4j-trace.properties");
    }

    public MethodExecutionTrace(String log4jPropertiesResourceName) {
        MemoryAppender.initialize();
        if (log4jPropertiesResourceName != null) {
            Properties log4j = new Properties();
            try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(log4jPropertiesResourceName);){
                if (in == null) {
                    throw new RuntimeException(String.format("Could not load resource %s", log4jPropertiesResourceName));
                }
                log4j.load(in);
                PropertyConfigurator.configure((Properties)log4j);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Could not load resource %s", log4jPropertiesResourceName), e);
            }
        }
    }

    public void starting(Description description) {
        System.out.println(description.getDisplayName() + " starting");
    }

    public void failed(Throwable e, Description description) {
        if (e instanceof AssumptionViolatedException) {
            System.out.println(String.format("%s skipped programmatically with reason: %s", this.getFullMethodName(description), e.getMessage()));
        } else {
            System.out.println(this.getFullMethodName(description) + " FAILED with exception " + e);
            e.printStackTrace(System.out);
            System.out.println("=================== BEGIN STORED LOG MESSAGES ===========================");
            MemoryAppender.printAllMessages();
            System.out.println("=================== END STORED LOG MESSAGES ===========================");
        }
        MemoryAppender.initialize();
    }

    public void succeeded(Description description) {
        System.out.println(this.getFullMethodName(description) + " " + "success");
        MemoryAppender.initialize();
    }

    private String getFullMethodName(Description description) {
        return description.getTestClass().getSimpleName() + "." + description.getMethodName();
    }
}

