/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.test.util;

import java.lang.reflect.Field;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.spi.LoggingEvent;

public class MemoryAppender
extends ConsoleAppender {
    private static final boolean DEBUG = false;
    private static Queue<LoggingEvent> eventsList = new LinkedBlockingQueue<LoggingEvent>();
    private static MemoryAppender lastInstance;
    private static int MAX_MESSAGES;
    private static AtomicInteger messageCount;
    private static String gatewayBeingStarted;
    private boolean printNow;
    private String gatewayName;

    public static void initialize() {
        eventsList.clear();
        lastInstance = null;
        messageCount.set(0);
        gatewayBeingStarted = null;
    }

    public static void printAllMessages() {
        if (lastInstance == null) {
            System.out.println("Unable to print out trace level root logger messages - please configure MemoryAppender on the <root> logger in log4j - config.xml");
        } else {
            System.out.println(String.format("Printing last %d of %d log messages", eventsList.size(), messageCount.get()));
            lastInstance.appendAll();
        }
    }

    public static void setGatewayBeingStarted(String gatewayName) {
        gatewayBeingStarted = gatewayName;
    }

    public MemoryAppender() {
        lastInstance = this;
        this.gatewayName = gatewayBeingStarted;
        this.debug("MemoryAppender instance " + this.toString() + " created");
    }

    protected void subAppend(LoggingEvent event) {
        if (this.printNow) {
            super.subAppend(event);
        } else {
            event.getThreadName();
            if (this.gatewayName != null) {
                this.injectGatewayName(event);
            }
            eventsList.add(event);
            if (messageCount.incrementAndGet() > MAX_MESSAGES) {
                eventsList.poll();
            }
        }
    }

    public void close() {
        this.debug("MemoryAppender instance " + (Object)((Object)this) + " closed");
    }

    public boolean requiresLayout() {
        return true;
    }

    public String toString() {
        String ret = super.toString();
        ret = ret + (this.gatewayName == null ? "" : " for gateway " + this.gatewayName);
        return ret;
    }

    private void appendAll() {
        this.printNow = true;
        try {
            for (LoggingEvent event : eventsList) {
                super.append(event);
            }
        }
        finally {
            eventsList.clear();
        }
        this.printNow = false;
    }

    private void debug(String message) {
    }

    private void injectGatewayName(LoggingEvent event) {
        if (!this.injectGatewayName(event, "renderedMessage")) {
            this.injectGatewayName(event, "message");
        }
    }

    private boolean injectGatewayName(LoggingEvent event, String fieldName) {
        try {
            Field field = LoggingEvent.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            String oldMessage = (String)field.get(event);
            if (oldMessage != null) {
                String newMessage = String.format("[%s gateway] %s", this.gatewayName, oldMessage);
                field.set(event, newMessage);
                if (oldMessage.contains("Started server successfully in ")) {
                    this.gatewayName = null;
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            System.out.println((Object)((Object)this) + ": caught exception " + e);
            return true;
        }
    }

    static {
        MAX_MESSAGES = 30000;
        messageCount = new AtomicInteger(0);
        MemoryAppender.initialize();
    }
}

