/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.netty.socket.nio;

import java.util.concurrent.Executor;
import org.jboss.netty.channel.ChannelConfig;
import org.jboss.netty.channel.socket.nio.AbstractNioWorker;
import org.jboss.netty.channel.socket.nio.NioSocketChannel;
import org.jboss.netty.channel.socket.nio.NioSocketChannelConfig;
import org.jboss.netty.channel.socket.nio.NioWorker;
import org.kaazing.mina.core.service.IoProcessorEx;
import org.kaazing.mina.netty.ChannelIoService;
import org.kaazing.mina.netty.ChannelIoSession;
import org.kaazing.mina.netty.socket.nio.NioSocketChannelIoSessionConfig;

public class NioSocketChannelIoSession
extends ChannelIoSession<NioSocketChannelConfig> {
    public NioSocketChannelIoSession(ChannelIoService service, IoProcessorEx<ChannelIoSession<? extends ChannelConfig>> processor, NioSocketChannel channel) {
        super(service, processor, channel, new NioSocketChannelIoSessionConfig(channel.getConfig()), Thread.currentThread(), NioSocketChannelIoSession.asExecutor(channel.getWorker()));
    }

    @Override
    protected void setIoAlignment0(Thread ioThread, Executor ioExecutor) {
        NioSocketChannel channel = (NioSocketChannel)this.getChannel();
        if (ioExecutor == NO_EXECUTOR) {
            channel.setWorker(null);
        } else if (this.isClosedReceived()) {
            this.getProcessor().remove(this);
        } else {
            AbstractNioWorker newWorker = ((ChannelIoSession.WorkerExecutor)ioExecutor).worker;
            channel.setWorker(newWorker);
        }
    }

    private static Executor asExecutor(NioWorker worker) {
        ChannelIoSession.WorkerExecutor executor = (ChannelIoSession.WorkerExecutor)CURRENT_WORKER.get();
        if (executor == null) {
            assert (NioSocketChannelIoSession.isInIoThread(worker)) : "Session created from non-I/O thread";
            executor = new ChannelIoSession.WorkerExecutor(worker);
            CURRENT_WORKER.set(executor);
        }
        assert (executor.worker == worker) : "Worker does not match I/O thread";
        return executor;
    }

    private static boolean isInIoThread(NioWorker worker) {
        boolean aligned;
        final Thread[] ioThread = new Thread[]{null};
        worker.executeInIoThread(new Runnable(){

            @Override
            public void run() {
                ioThread[0] = Thread.currentThread();
            }
        });
        boolean bl = aligned = ioThread[0] == Thread.currentThread();
        assert (aligned) : String.format("Current thread %s does not match I/O thread %s", Thread.currentThread(), ioThread[0]);
        return aligned;
    }
}

