/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.netty;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.file.FileRegion;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.filterchain.IoFilterChainBuilder;
import org.apache.mina.core.service.IoServiceListenerSupport;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.core.write.WriteRequestQueue;
import org.apache.mina.core.write.WriteToClosedSessionException;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelConfig;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.core.service.AbstractIoProcessor;
import org.kaazing.mina.netty.ChannelIoBufferAllocator;
import org.kaazing.mina.netty.ChannelIoSession;
import org.kaazing.mina.netty.ChannelWriteFutureListener;
import org.kaazing.mina.netty.channel.DownstreamMessageEventEx;
import org.kaazing.mina.netty.util.threadlocal.VicariousThreadLocal;
import org.kaazing.mina.util.ExceptionMonitor;

final class ChannelIoProcessor
extends AbstractIoProcessor<ChannelIoSession<? extends ChannelConfig>> {
    private final ResetableThreadLocal<DownstreamMessageEventEx> writeRequestEx = new ResetableThreadLocal<DownstreamMessageEventEx>(){

        @Override
        protected DownstreamMessageEventEx initialValue() {
            return new DownstreamMessageEventEx();
        }
    };

    ChannelIoProcessor() {
    }

    @Override
    protected void add0(ChannelIoSession<? extends ChannelConfig> session) {
        this.addNow(session);
    }

    @Override
    protected void remove0(ChannelIoSession<? extends ChannelConfig> session) {
        this.removeNow(session);
    }

    @Override
    protected void flush0(ChannelIoSession<? extends ChannelConfig> session) {
        this.flushNow(session);
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

    @Override
    public boolean isDisposing() {
        return false;
    }

    @Override
    protected void updateTrafficControl0(ChannelIoSession<? extends ChannelConfig> session) {
        throw new UnsupportedOperationException();
    }

    protected void init(ChannelIoSession<? extends ChannelConfig> session) {
    }

    protected void destroy(ChannelIoSession<? extends ChannelConfig> session) {
        session.getChannel().close();
    }

    private void addNow(ChannelIoSession<? extends ChannelConfig> session) {
        try {
            this.init(session);
            IoFilterChainBuilder chainBuilder = session.getService().getFilterChainBuilder();
            chainBuilder.buildFilterChain(session.getFilterChain());
            IoServiceListenerSupport listeners = session.getService().getListeners();
            listeners.fireSessionCreated(session);
        }
        catch (Throwable e) {
            ExceptionMonitor.getInstance().exceptionCaught(e, session);
            try {
                this.destroy(session);
            }
            catch (Exception e1) {
                ExceptionMonitor.getInstance().exceptionCaught(e1, session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeNow(ChannelIoSession<? extends ChannelConfig> session) {
        this.clearWriteRequestQueue(session);
        try {
            this.destroy(session);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            IoFilterChain filterChain = session.getFilterChain();
            filterChain.fireExceptionCaught(e);
        }
        finally {
            this.clearWriteRequestQueue(session);
            session.getService().getListeners().fireSessionDestroyed(session);
        }
        return false;
    }

    private void clearWriteRequestQueue(ChannelIoSession<? extends ChannelConfig> session) {
        WriteRequestQueue writeRequestQueue = session.getWriteRequestQueue();
        ArrayList<WriteRequest> failedRequests = new ArrayList<WriteRequest>();
        WriteRequest req = writeRequestQueue.poll(session);
        if (req != null) {
            Object message = req.getMessage();
            if (message instanceof IoBuffer) {
                IoBuffer buf = (IoBuffer)message;
                if (buf.hasRemaining()) {
                    buf.reset();
                    failedRequests.add(req);
                } else {
                    IoFilterChain filterChain = session.getFilterChain();
                    filterChain.fireMessageSent(req);
                }
            } else {
                failedRequests.add(req);
            }
            while ((req = writeRequestQueue.poll(session)) != null) {
                failedRequests.add(req);
            }
        }
        if (!failedRequests.isEmpty()) {
            WriteToClosedSessionException cause = new WriteToClosedSessionException(failedRequests);
            for (WriteRequest r : failedRequests) {
                session.decreaseScheduledBytesAndMessages(r);
                r.getFuture().setException(cause);
            }
            IoFilterChain filterChain = session.getFilterChain();
            filterChain.fireExceptionCaught(cause);
        }
    }

    private boolean flushNow(ChannelIoSession<? extends ChannelConfig> session) {
        if (!session.isConnected()) {
            this.removeNow(session);
            return false;
        }
        WriteRequestQueue writeRequestQueue = session.getWriteRequestQueue();
        Channel channel = session.getChannel();
        IoFilterChain filterChain = session.getFilterChain();
        WriteRequest req = null;
        try {
            while ((req = writeRequestQueue.poll(session)) != null) {
                ChannelFuture future;
                Object message = req.getMessage();
                if (message instanceof ChannelIoBufferAllocator.ChannelIoBuffer) {
                    ChannelIoBufferAllocator.ChannelIoBuffer channelIoBuf = (ChannelIoBufferAllocator.ChannelIoBuffer)message;
                    if (channelIoBuf.remaining() == 0) {
                        filterChain.fireMessageSent(req);
                        continue;
                    }
                    if (channelIoBuf.isShared()) {
                        ByteBuffer sharedBuf = channelIoBuf.buf();
                        int position = sharedBuf.position();
                        DownstreamMessageEventEx writeRequest = (DownstreamMessageEventEx)this.writeRequestEx.get();
                        if (!writeRequest.isResetable()) {
                            writeRequest = this.writeRequestEx.reset();
                        }
                        assert (writeRequest.isResetable());
                        writeRequest.reset(channel, sharedBuf, null, false);
                        ChannelPipeline pipeline = channel.getPipeline();
                        pipeline.sendDownstream(writeRequest);
                        ChannelFuture future2 = writeRequest.getFuture();
                        if (future2.isDone()) {
                            sharedBuf.position(position);
                            ChannelWriteFutureListener.operationComplete(future2, filterChain, req);
                            continue;
                        }
                        ByteBuffer newSharedBuf = sharedBuf.duplicate();
                        newSharedBuf.position(position);
                        channelIoBuf.buf(newSharedBuf);
                        future2.addListener(new ChannelWriteFutureListener(filterChain, req));
                        continue;
                    }
                    ByteBuffer unsharedBuf = channelIoBuf.buf();
                    DownstreamMessageEventEx writeRequest = (DownstreamMessageEventEx)this.writeRequestEx.get();
                    if (!writeRequest.isResetable()) {
                        writeRequest = this.writeRequestEx.reset();
                    }
                    assert (writeRequest.isResetable());
                    writeRequest.reset(channel, unsharedBuf, null, false);
                    ChannelPipeline pipeline = channel.getPipeline();
                    pipeline.sendDownstream(writeRequest);
                    ChannelFuture future3 = writeRequest.getFuture();
                    if (future3.isDone()) {
                        ChannelWriteFutureListener.operationComplete(future3, filterChain, req);
                        continue;
                    }
                    future3.addListener(new ChannelWriteFutureListener(filterChain, req));
                    continue;
                }
                if (message instanceof FileRegion) {
                    FileRegion region = (FileRegion)message;
                    future = channel.write(region);
                    future.addListener(new ChannelWriteFutureListener(filterChain, req));
                    continue;
                }
                if (message instanceof IoBufferEx && ((IoBufferEx)message).isShared()) {
                    String messageClassName = message.getClass().getName();
                    throw new IllegalStateException(String.format("Shared buffer MUST be ChannelIoBuffer, not %s", messageClassName));
                }
                if (message instanceof IoBuffer) {
                    IoBuffer buf = (IoBuffer)message;
                    if (buf.remaining() == 0) {
                        filterChain.fireMessageSent(req);
                        continue;
                    }
                    future = channel.write(ChannelBuffers.wrappedBuffer(buf.buf()));
                    future.addListener(new ChannelWriteFutureListener(filterChain, req));
                    continue;
                }
                throw new IllegalStateException("Don't know how to handle message of type '" + message.getClass().getName() + "'.  Are you missing a protocol encoder?");
            }
        }
        catch (Exception e) {
            if (req != null) {
                req.getFuture().setException(e);
            }
            filterChain.fireExceptionCaught(e);
            return false;
        }
        return true;
    }

    private static class ResetableThreadLocal<T>
    extends VicariousThreadLocal<T> {
        private ResetableThreadLocal() {
        }

        public T reset() {
            Object newValue = this.initialValue();
            this.set(newValue);
            return newValue;
        }
    }
}

