/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.filter.codec.statemachine;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.statemachine.DecodingState;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;

public abstract class ConsumeToTerminatorDecodingState
implements DecodingState {
    private final IoBufferAllocatorEx<?> allocator;
    private final byte terminator;
    private IoBuffer buffer;

    public ConsumeToTerminatorDecodingState(IoBufferAllocatorEx<?> allocator, byte terminator) {
        this.allocator = allocator;
        this.terminator = terminator;
    }

    @Override
    public DecodingState decode(IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        int terminatorPos = in.indexOf(this.terminator);
        if (terminatorPos >= 0) {
            IoBuffer product;
            int limit = in.limit();
            if (in.position() < terminatorPos) {
                in.limit(terminatorPos);
                if (this.buffer == null) {
                    product = in.slice();
                } else {
                    this.buffer.put(in);
                    product = this.buffer.flip();
                    this.buffer = null;
                }
                in.limit(limit);
            } else if (this.buffer == null) {
                product = (IoBuffer)this.allocator.wrap(this.allocator.allocate(0));
            } else {
                this.buffer.flip();
                product = this.buffer;
                this.buffer = null;
            }
            in.position(terminatorPos + 1);
            return this.finishDecode(product, out);
        }
        if (this.buffer == null) {
            this.buffer = (IoBuffer)((Object)this.allocator.wrap(this.allocator.allocate(in.remaining())).setAutoExpander(this.allocator));
        }
        this.buffer.put(in);
        return this;
    }

    @Override
    public DecodingState finishDecode(ProtocolDecoderOutput out) throws Exception {
        IoBuffer product;
        if (this.buffer == null) {
            product = (IoBuffer)this.allocator.wrap(this.allocator.allocate(0));
        } else {
            product = this.buffer.flip();
            this.buffer = null;
        }
        return this.finishDecode(product, out);
    }

    protected abstract DecodingState finishDecode(IoBuffer var1, ProtocolDecoderOutput var2) throws Exception;
}

