/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.polling.AbstractPollingConnectionlessIoAcceptor;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.transport.socket.DatagramAcceptorEx;
import org.apache.mina.transport.socket.DatagramSessionConfigEx;
import org.apache.mina.transport.socket.DefaultDatagramSessionConfigEx;
import org.apache.mina.transport.socket.nio.NioDatagramSessionConfigEx;
import org.apache.mina.transport.socket.nio.NioDatagramSessionEx;
import org.apache.mina.transport.socket.nio.NioSession;
import org.kaazing.mina.core.buffer.SimpleBufferAllocator;
import org.kaazing.mina.core.future.BindFuture;
import org.kaazing.mina.core.future.DefaultBindFuture;
import org.kaazing.mina.core.future.DefaultUnbindFuture;
import org.kaazing.mina.core.future.UnbindFuture;
import org.kaazing.mina.core.write.DefaultWriteRequestEx;
import org.kaazing.mina.core.write.WriteRequestEx;

public final class NioDatagramAcceptorEx
extends AbstractPollingConnectionlessIoAcceptor<NioSession, DatagramChannel>
implements DatagramAcceptorEx {
    private final List<ThreadLocal<WriteRequestEx>> sharedWriteRequests = DefaultWriteRequestEx.ShareableWriteRequest.initWithLayers(16);
    private volatile Selector selector;

    public NioDatagramAcceptorEx() {
        super(new DefaultDatagramSessionConfigEx());
    }

    public NioDatagramAcceptorEx(Executor executor) {
        super(new DefaultDatagramSessionConfigEx(), executor);
    }

    @Override
    public ThreadLocal<WriteRequestEx> getThreadLocalWriteRequest(int ioLayer) {
        return this.sharedWriteRequests.get(ioLayer);
    }

    @Override
    protected void init() throws Exception {
        this.selector = Selector.open();
    }

    @Override
    protected void destroy() throws Exception {
        if (this.selector != null) {
            this.selector.close();
        }
    }

    @Override
    public TransportMetadata getTransportMetadata() {
        return NioDatagramSessionEx.METADATA;
    }

    @Override
    public DatagramSessionConfigEx getSessionConfig() {
        return (DatagramSessionConfigEx)super.getSessionConfig();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)super.getLocalAddress();
    }

    @Override
    public InetSocketAddress getDefaultLocalAddress() {
        return (InetSocketAddress)super.getDefaultLocalAddress();
    }

    @Override
    public void setDefaultLocalAddress(InetSocketAddress localAddress) {
        this.setDefaultLocalAddress((SocketAddress)localAddress);
    }

    @Override
    public BindFuture bindAsync(SocketAddress localAddress) {
        try {
            this.bind(localAddress);
            return DefaultBindFuture.succeededFuture();
        }
        catch (IOException e) {
            DefaultBindFuture future = new DefaultBindFuture();
            future.setException(e);
            return future;
        }
    }

    @Override
    public UnbindFuture unbindAsync(SocketAddress localAddress) {
        try {
            this.unbind(localAddress);
            return DefaultUnbindFuture.succeededFuture();
        }
        catch (Exception e) {
            DefaultUnbindFuture future = new DefaultUnbindFuture();
            future.setException(e);
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DatagramChannel open(SocketAddress localAddress) throws Exception {
        DatagramChannel c = DatagramChannel.open();
        boolean success = false;
        try {
            new NioDatagramSessionConfigEx(c).setAll(this.getSessionConfig());
            c.configureBlocking(false);
            c.socket().bind(localAddress);
            c.register(this.selector, 1);
            success = true;
        }
        finally {
            if (!success) {
                this.close(c);
            }
        }
        return c;
    }

    @Override
    protected boolean isReadable(DatagramChannel handle) {
        SelectionKey key = handle.keyFor(this.selector);
        if (key == null || !key.isValid()) {
            return false;
        }
        return key.isReadable();
    }

    @Override
    protected boolean isWritable(DatagramChannel handle) {
        SelectionKey key = handle.keyFor(this.selector);
        if (key == null || !key.isValid()) {
            return false;
        }
        return key.isWritable();
    }

    @Override
    protected SocketAddress localAddress(DatagramChannel handle) throws Exception {
        return handle.socket().getLocalSocketAddress();
    }

    @Override
    protected NioSession newSession(IoProcessor<NioSession> processor, DatagramChannel handle, SocketAddress remoteAddress) {
        SelectionKey key = handle.keyFor(this.selector);
        if (key == null || !key.isValid()) {
            return null;
        }
        NioDatagramSessionEx newSession = new NioDatagramSessionEx(this, handle, processor, remoteAddress);
        newSession.setSelectionKey(key);
        return newSession;
    }

    @Override
    protected SocketAddress receive(DatagramChannel handle, IoBuffer buffer) throws Exception {
        return handle.receive(buffer.buf());
    }

    @Override
    protected int select() throws Exception {
        return this.selector.select();
    }

    @Override
    protected int select(int timeout) throws Exception {
        return this.selector.select(timeout);
    }

    @Override
    protected Iterator<DatagramChannel> selectedHandles() {
        return new DatagramChannelIterator(this.selector.selectedKeys());
    }

    @Override
    protected int send(NioSession session, IoBuffer buffer, SocketAddress remoteAddress) throws Exception {
        return ((DatagramChannel)session.getChannel()).send(buffer.buf(), remoteAddress);
    }

    @Override
    protected void setInterestedInWrite(NioSession session, boolean interested) throws Exception {
        SelectionKey key = session.getSelectionKey();
        if (key == null) {
            return;
        }
        if (interested) {
            key.interestOps(key.interestOps() | 4);
        } else {
            key.interestOps(key.interestOps() & 0xFFFFFFFB);
        }
    }

    @Override
    protected void close(DatagramChannel handle) throws Exception {
        SelectionKey key = handle.keyFor(this.selector);
        if (key != null) {
            key.cancel();
        }
        handle.disconnect();
        handle.close();
    }

    @Override
    protected void wakeup() {
        this.selector.wakeup();
    }

    @Override
    protected IoBuffer newReadBuffer(int readBufferSize) {
        return SimpleBufferAllocator.BUFFER_ALLOCATOR.wrap(ByteBuffer.allocate(readBufferSize));
    }

    private static final class DatagramChannelIterator
    implements Iterator<DatagramChannel> {
        private final Iterator<SelectionKey> i;

        private DatagramChannelIterator(Collection<SelectionKey> keys) {
            this.i = keys.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public DatagramChannel next() {
            return (DatagramChannel)this.i.next().channel();
        }

        @Override
        public void remove() {
            this.i.remove();
        }
    }
}

