/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.netty;

import java.net.SocketAddress;
import java.util.concurrent.Executor;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.TransportMetadata;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelConfig;
import org.jboss.netty.channel.socket.nio.AbstractNioWorker;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.service.IoProcessorEx;
import org.kaazing.mina.core.session.AbstractIoSessionEx;
import org.kaazing.mina.netty.ChannelIoBufferAllocator;
import org.kaazing.mina.netty.ChannelIoService;
import org.kaazing.mina.netty.ChannelIoSessionConfig;

public class ChannelIoSession<C extends ChannelConfig>
extends AbstractIoSessionEx {
    private static final IoBufferAllocatorEx<ChannelIoBufferAllocator.ChannelIoBuffer> BUFFER_ALLOCATOR = new ChannelIoBufferAllocator();
    private final ChannelIoService service;
    private final Channel channel;
    private final ChannelIoSessionConfig<C> config;
    private final IoHandler handler;
    private final IoProcessorEx<ChannelIoSession<? extends ChannelConfig>> processor;
    private final TransportMetadata transportMetadata;
    private volatile boolean closedReceived;

    public ChannelIoSession(ChannelIoService service, IoProcessorEx<ChannelIoSession<? extends ChannelConfig>> processor, Channel channel, ChannelIoSessionConfig<C> config, Thread ioThread, Executor ioExecutor) {
        super(0, ioThread, ioExecutor, service.getThreadLocalWriteRequest(0));
        this.service = service;
        this.channel = channel;
        this.config = config;
        this.config.setAll(service.getSessionConfig());
        this.handler = service.getHandler();
        this.processor = processor;
        this.transportMetadata = service.getTransportMetadata();
    }

    public IoBufferAllocatorEx<ChannelIoBufferAllocator.ChannelIoBuffer> getBufferAllocator() {
        return BUFFER_ALLOCATOR;
    }

    @Override
    public ChannelIoService getService() {
        return this.service;
    }

    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public IoHandler getHandler() {
        return this.handler;
    }

    @Override
    public ChannelIoSessionConfig<C> getConfig() {
        return this.config;
    }

    @Override
    public IoProcessorEx<ChannelIoSession<? extends ChannelConfig>> getProcessor() {
        return this.processor;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.channel.getLocalAddress();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.channel.getRemoteAddress();
    }

    @Override
    public TransportMetadata getTransportMetadata() {
        return this.transportMetadata;
    }

    @Override
    public boolean isReadSuspended() {
        return this.channel.isReadable();
    }

    @Override
    public void resumeRead() {
        this.channel.setReadable(true);
    }

    @Override
    public void suspendRead() {
        this.channel.setReadable(false);
    }

    protected boolean isClosedReceived() {
        return this.closedReceived;
    }

    void setClosedReceived() {
        this.closedReceived = true;
    }

    public static final class WorkerExecutor
    implements Executor {
        public final AbstractNioWorker worker;

        public WorkerExecutor(AbstractNioWorker worker) {
            this.worker = worker;
        }

        @Override
        public void execute(Runnable command) {
            this.worker.executeInIoThread(command, true);
        }
    }
}

