/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.netty;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.DefaultConnectFuture;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.session.IoSessionInitializer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelConfig;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.kaazing.mina.core.service.AbstractIoConnectorEx;
import org.kaazing.mina.core.service.IoProcessorEx;
import org.kaazing.mina.core.session.IoSessionConfigEx;
import org.kaazing.mina.netty.ChannelIoProcessor;
import org.kaazing.mina.netty.ChannelIoService;
import org.kaazing.mina.netty.ChannelIoSession;
import org.kaazing.mina.netty.DefaultIoSessionIdleTracker;
import org.kaazing.mina.netty.IoConnectorChannelHandlerFactory;
import org.kaazing.mina.netty.IoSessionIdleTracker;
import org.kaazing.mina.netty.bootstrap.ClientBootstrap;
import org.kaazing.mina.netty.bootstrap.ClientBootstrapFactory;
import org.kaazing.mina.netty.util.threadlocal.VicariousThreadLocal;

public abstract class ChannelIoConnector<C extends IoSessionConfigEx, F extends ChannelFactory, A extends SocketAddress>
extends AbstractIoConnectorEx
implements ChannelIoService {
    private final F channelFactory;
    private ChannelPipelineFactory pipelineFactory;
    private final ChannelGroup channelGroup;
    private final IoProcessorEx<ChannelIoSession<? extends ChannelConfig>> processor = new ChannelIoProcessor();
    private final ClientBootstrapFactory bootstrapFactory;
    private final IoConnectorChannelHandlerFactory handlerFactory;
    private final List<IoSessionIdleTracker> sessionIdleTrackers = Collections.synchronizedList(new ArrayList());
    private final ThreadLocal<IoSessionIdleTracker> currentSessionIdleTracker = new VicariousThreadLocal<IoSessionIdleTracker>(){

        @Override
        protected IoSessionIdleTracker initialValue() {
            DefaultIoSessionIdleTracker result = new DefaultIoSessionIdleTracker();
            ChannelIoConnector.this.sessionIdleTrackers.add(result);
            return result;
        }
    };

    public ChannelIoConnector(C sessionConfig, F channelFactory, IoConnectorChannelHandlerFactory handlerFactory, ClientBootstrapFactory bootstrapFactory) {
        super((IoSessionConfigEx)sessionConfig, new Executor(){

            @Override
            public void execute(Runnable command) {
            }
        });
        this.channelFactory = channelFactory;
        this.channelGroup = new DefaultChannelGroup();
        this.bootstrapFactory = bootstrapFactory;
        this.handlerFactory = handlerFactory;
    }

    public void setPipelineFactory(ChannelPipelineFactory pipelineFactory) {
        this.pipelineFactory = pipelineFactory;
    }

    public final ChannelIoSession<? extends ChannelConfig> createSession(Channel channel) {
        return this.createSession(channel, this.processor);
    }

    protected abstract ChannelIoSession<? extends ChannelConfig> createSession(Channel var1, IoProcessorEx<ChannelIoSession<? extends ChannelConfig>> var2);

    @Override
    protected ConnectFuture connect0(SocketAddress remoteAddress, SocketAddress localAddress, IoSessionInitializer<? extends ConnectFuture> sessionInitializer) {
        ChannelPipeline newPipeline;
        final DefaultConnectFuture connectFuture = new DefaultConnectFuture();
        ChannelFactory bootstrapChannelFactory = new ChannelFactory(){

            @Override
            public Channel newChannel(ChannelPipeline pipeline) {
                Channel newChannel = ChannelIoConnector.this.channelFactory.newChannel(pipeline);
                ChannelConfig newChannelConfig = newChannel.getConfig();
                newChannelConfig.setConnectTimeoutMillis((int)ChannelIoConnector.this.getConnectTimeoutMillis());
                return newChannel;
            }

            @Override
            public void releaseExternalResources() {
                ChannelIoConnector.this.channelFactory.releaseExternalResources();
            }

            @Override
            public void shutdown() {
                ChannelIoConnector.this.channelFactory.shutdown();
            }
        };
        ClientBootstrap bootstrap = this.bootstrapFactory.createBootstrap();
        bootstrap.setFactory(bootstrapChannelFactory);
        if (this.pipelineFactory != null) {
            try {
                newPipeline = this.pipelineFactory.getPipeline();
            }
            catch (Exception e) {
                connectFuture.setException(e);
                return connectFuture;
            }
        } else {
            newPipeline = Channels.pipeline();
        }
        newPipeline.addLast("mina-bridge", this.handlerFactory.createHandler(this, connectFuture, sessionInitializer));
        bootstrap.setPipeline(newPipeline);
        ChannelFuture channelFuture = bootstrap.connect(remoteAddress, localAddress);
        channelFuture.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    connectFuture.setException(future.getCause());
                } else {
                    ChannelIoConnector.this.channelGroup.add(future.getChannel());
                }
            }
        });
        return connectFuture;
    }

    @Override
    protected IoFuture dispose0() throws Exception {
        this.channelGroup.close().await();
        this.channelFactory.releaseExternalResources();
        for (IoSessionIdleTracker tracker : this.sessionIdleTrackers) {
            tracker.dispose();
        }
        return null;
    }

    protected IoProcessorEx<ChannelIoSession<? extends ChannelConfig>> getProcessor() {
        return this.processor;
    }

    @Override
    public IoSessionIdleTracker getSessionIdleTracker() {
        return this.currentSessionIdleTracker.get();
    }

    @Override
    public void initializeSession(ChannelIoSession<?> session, IoFuture future, IoSessionInitializer<?> initializer) {
        this.initSession(session, future, initializer);
    }

    public C getSessionConfig() {
        return (C)super.getSessionConfig();
    }

    public A getDefaultRemoteAddress() {
        return (A)super.getDefaultRemoteAddress();
    }
}

