/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.util.concurrent.Executor;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.socket.DatagramChannel;
import org.jboss.netty.channel.socket.DatagramChannelFactory;
import org.jboss.netty.channel.socket.InternetProtocolFamily;
import org.jboss.netty.channel.socket.nio.AbstractNioWorker;
import org.jboss.netty.channel.socket.nio.BossPool;
import org.jboss.netty.channel.socket.nio.NioChildDatagramChannel;
import org.jboss.netty.channel.socket.nio.NioChildDatagramPipelineSink;
import org.jboss.netty.channel.socket.nio.NioDatagramBossPool;
import org.jboss.netty.channel.socket.nio.NioDatagramChannel;
import org.jboss.netty.channel.socket.nio.NioDatagramPipelineSink;
import org.jboss.netty.channel.socket.nio.NioServerDatagramBoss;
import org.jboss.netty.channel.socket.nio.NioWorker;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.util.ExternalResourceReleasable;

public class NioServerDatagramChannelFactory
implements DatagramChannelFactory {
    private final NioDatagramPipelineSink sink;
    private final NioChildDatagramPipelineSink childSink;
    private final BossPool<NioServerDatagramBoss> bossPool;
    private final WorkerPool<NioWorker> workerPool;
    private final InternetProtocolFamily family;
    private boolean releasePool;

    public NioServerDatagramChannelFactory(Executor bossExecutor, int bossCount, WorkerPool<NioWorker> workerPool) {
        this.bossPool = new NioDatagramBossPool(bossExecutor, bossCount, null);
        this.workerPool = workerPool;
        this.family = null;
        this.sink = new NioDatagramPipelineSink();
        this.childSink = new NioChildDatagramPipelineSink();
        this.releasePool = true;
    }

    @Override
    public DatagramChannel newChannel(ChannelPipeline pipeline) {
        return new NioDatagramChannel(this, pipeline, this.sink, this.bossPool.nextBoss(), this.family);
    }

    public NioChildDatagramChannel newChildChannel(Channel parent, ChannelPipeline pipeline) {
        return new NioChildDatagramChannel(parent, (ChannelFactory)this, pipeline, (ChannelSink)this.childSink, (AbstractNioWorker)this.workerPool.nextWorker(), this.family);
    }

    @Override
    public void shutdown() {
        this.workerPool.shutdown();
        this.bossPool.shutdown();
        if (this.releasePool) {
            this.releasePool();
        }
    }

    @Override
    public void releaseExternalResources() {
        this.workerPool.shutdown();
        this.bossPool.shutdown();
        this.releasePool();
    }

    private void releasePool() {
        if (this.workerPool instanceof ExternalResourceReleasable) {
            ((ExternalResourceReleasable)((Object)this.workerPool)).releaseExternalResources();
        }
        if (this.bossPool instanceof ExternalResourceReleasable) {
            ((ExternalResourceReleasable)((Object)this.bossPool)).releaseExternalResources();
        }
    }
}

